/// <reference path="./internal_*.d.ts" />
declare namespace it.unimi.dsi.fastutil {
    interface Function <K, V> extends Internal.Function<K, V> {
        size(): number;
        apply(arg0: K): V;
        containsKey(arg0: any): boolean;
        put(arg0: K, arg1: V): V;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<K, V>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, V>;
        clear(): void;
        getOrDefault(arg0: any, arg1: V): V;
        abstract get(arg0: any): V;
        remove(arg0: any): V;
        identity<T>(): Internal.Function<T, T>;
        (arg0: any): V;
    }
    type Function_<K, V> = Function<K, V>;
}
declare namespace slimeknights.tconstruct.fluids.item {
    class BottleItem extends Internal.Item {
        constructor(potion: Internal.ItemLike_, props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BottleItem_ = BottleItem;
}
declare namespace Internal {
    class TravelersGearItem extends Internal.ModifiableArmorItem implements Internal.ArmorTextureItem {
        constructor(material: any_, slotType: any_, properties: Internal.Item$Properties_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static getDisplayStack(item: Internal.Item_): Internal.ItemStack;
        initializeClient(): void;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLocalizedName(): net.minecraft.network.chat.Component;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        doVanillaElytraTick(entity: Internal.LivingEntity_, chestStack: Internal.ItemStack_): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        getArmorTexture(stack: Internal.ItemStack_, entity: Internal.Entity_, slot: Internal.EquipmentSlot_, type: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static setRarity(volatileData: Internal.ModDataNBT_, rarity: Internal.Rarity_): void;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get localizedName(): net.minecraft.network.chat.Component
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type TravelersGearItem_ = TravelersGearItem;
    interface Equipable extends Internal.Vanishable {
        abstract getEquipmentSlot(): Internal.EquipmentSlot;
        get($$0: Internal.ItemStack_): this;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getEquipSound(): Internal.SoundEvent;
        get equipmentSlot(): Internal.EquipmentSlot
        get equipSound(): Internal.SoundEvent
        (): Internal.EquipmentSlot_;
    }
    type Equipable_ = Equipable;
    class JsonRecipeJS extends Internal.RecipeJS {
        constructor()
        getMod(): string;
        get mod(): string
    }
    type JsonRecipeJS_ = JsonRecipeJS;
    class TurtleOverlayRecipe extends Internal.CustomShapelessRecipe {
        constructor(id: ResourceLocation_, spec: Internal.ShapelessRecipeSpec_, overlay: ResourceLocation_)
        isSpecial(): boolean;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        getSerializer(): Internal.RecipeSerializer<Internal.TurtleOverlayRecipe>;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get serializer(): Internal.RecipeSerializer<Internal.TurtleOverlayRecipe>
        get mod(): string
    }
    type TurtleOverlayRecipe_ = TurtleOverlayRecipe;
    class TelemetryEventType {
        id(): string;
        isOptIn(): boolean;
        title(): Internal.MutableComponent;
        codec(): Internal.Codec<Internal.TelemetryEventInstance>;
        static values(): Internal.List<Internal.TelemetryEventType>;
        export($$0: Internal.TelemetrySession_, $$1: Internal.TelemetryPropertyMap_): Internal.TelemetryEvent;
        static builder($$0: string, $$1: string): Internal.TelemetryEventType$Builder;
        description(): Internal.MutableComponent;
        properties(): Internal.List<Internal.TelemetryProperty<any>>;
        contains<T>($$0: Internal.TelemetryProperty_<T>): boolean;
        get optIn(): boolean
        static readonly PERFORMANCE_METRICS: Internal.TelemetryEventType;
        static readonly GAME_LOAD_TIMES: Internal.TelemetryEventType;
        static readonly WORLD_UNLOADED: Internal.TelemetryEventType;
        static readonly WORLD_LOADED: Internal.TelemetryEventType;
        static readonly WORLD_LOAD_TIMES: Internal.TelemetryEventType;
        static readonly ADVANCEMENT_MADE: Internal.TelemetryEventType;
        static readonly CODEC: Internal.Codec<Internal.TelemetryEventType>;
    }
    type TelemetryEventType_ = TelemetryEventType;
    interface DataProvider$Factory <T extends Internal.DataProvider> {
        abstract create(arg0: Internal.PackOutput_): T;
        (arg0: Internal.PackOutput): T;
    }
    type DataProvider$Factory_<T extends Internal.DataProvider> = DataProvider$Factory<T>;
    class TrackShape extends Internal.Enum<Internal.TrackShape> implements Internal.StringRepresentable {
        getModelRotation(): number;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf(name: string): Internal.TrackShape;
        getSerializedName(): string;
        mirror(mirror: Internal.Mirror_): this;
        isJunction(): boolean;
        static values(): Internal.TrackShape[];
        getAxes(): Internal.List<Vec3d>;
        static asPortal(horizontalFacing: Internal.Direction_): Internal.TrackShape;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        getModel(): string;
        isPortal(): boolean;
        getNormal(): Vec3d;
        rotate(rotation: Internal.Rotation_): this;
        get modelRotation(): number
        get serializedName(): string
        get junction(): boolean
        get axes(): Internal.List<Vec3d>
        get model(): string
        get portal(): boolean
        get normal(): Vec3d
        static readonly CR_PDX: Internal.TrackShape;
        static readonly CR_PDZ: Internal.TrackShape;
        static readonly TS: Internal.TrackShape;
        static readonly CR_NDZ: Internal.TrackShape;
        static readonly NONE: Internal.TrackShape;
        static readonly CR_D: Internal.TrackShape;
        static readonly CR_NDX: Internal.TrackShape;
        static readonly AE: Internal.TrackShape;
        static readonly TW: Internal.TrackShape;
        static readonly AS: Internal.TrackShape;
        static readonly TE: Internal.TrackShape;
        static readonly AN: Internal.TrackShape;
        static readonly CR_O: Internal.TrackShape;
        static readonly TN: Internal.TrackShape;
        static readonly XO: Internal.TrackShape;
        static readonly ZO: Internal.TrackShape;
        static readonly ND: Internal.TrackShape;
        static readonly AW: Internal.TrackShape;
        static readonly PD: Internal.TrackShape;
    }
    type TrackShape_ = "cr_d" | "cr_pdz" | "an" | "cr_pdx" | "cr_ndx" | "cr_ndz" | "tw" | "ae" | "cr_o" | "none" | TrackShape | "ts" | "tn" | "xo" | "zo" | "aw" | "nd" | "pd" | "te" | "as";
    class BacktankItem extends Internal.BaseArmorItem implements Internal.CapacityEnchantment$ICapacityEnchantable {
        constructor(material: Internal.ArmorMaterial_, properties: Internal.Item$Properties_, textureLoc: ResourceLocation_, placeable: Internal.Supplier_<Internal.BacktankItem$BacktankBlockItem>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        static getWornBy(entity: Internal.Entity_): Internal.BacktankItem;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static getRemainingAir(stack: Internal.ItemStack_): number;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        getBlock(): Internal.Block;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get block(): Internal.Block
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly BAR_COLOR: 15724527;
        static readonly SLOT: Internal.EquipmentSlot;
        static readonly TYPE: Internal.ArmorItem$Type;
    }
    type BacktankItem_ = BacktankItem;
    class WhistleBlockEntity extends Internal.SmartBlockEntity implements Internal.IHaveGoggleInformation {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getPitchId(): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTank(): Internal.FluidTankBlockEntity;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        updatePitch(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get pitchId(): number
        get tank(): Internal.FluidTankBlockEntity
        get infiniteBoundingBox(): Internal.AABB
        source: Internal.WeakReference<Internal.FluidTankBlockEntity>;
        animation: Internal.LerpedFloat;
    }
    type WhistleBlockEntity_ = WhistleBlockEntity;
    interface BlockApiLookup$BlockApiProvider <A, C> {
        abstract find(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockEntity_, arg4: C): A;
        (arg0: Internal.Level, arg1: BlockPos, arg2: Internal.BlockState, arg3: Internal.BlockEntity, arg4: C): A;
    }
    type BlockApiLookup$BlockApiProvider_<A, C> = BlockApiLookup$BlockApiProvider<A, C>;
    class CasingBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable {
        constructor(p_i48440_1_: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type CasingBlock_ = CasingBlock;
    interface C2SPacket extends me.pepperbell.simplenetworking.Packet {
        abstract encode(arg0: Internal.FriendlyByteBuf_): void;
        abstract handle(arg0: Internal.MinecraftServer_, arg1: Internal.ServerPlayer_, arg2: Internal.ServerGamePacketListenerImpl_, arg3: Internal.PacketSender_, arg4: Internal.SimpleChannel_): void;
    }
    type C2SPacket_ = C2SPacket;
    interface ShortBidirectionalIterator extends Internal.ShortIterator, Internal.ObjectBidirectionalIterator<number> {
        abstract previousShort(): number;
        forEachRemaining(arg0: any): void;
        /**
         * @deprecated
        */
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        skip(arg0: number): number;
        /**
         * @deprecated
        */
        next(): any;
        forEachRemaining(arg0: Internal.IntConsumer_): void;
        abstract nextShort(): number;
        forEachRemaining(arg0: Internal.ShortConsumer_): void;
        /**
         * @deprecated
        */
        previous(): number;
        abstract hasPrevious(): boolean;
        remove(): void;
        back(arg0: number): number;
        abstract hasNext(): boolean;
    }
    type ShortBidirectionalIterator_ = ShortBidirectionalIterator;
    interface TypeDescriptor {
        abstract descriptorString(): string;
        (): string;
    }
    type TypeDescriptor_ = TypeDescriptor;
    class HorizontalAlignment extends Internal.Enum<Internal.HorizontalAlignment> {
        align(componentWidth: number, span: number): number;
        static valueOf(name: string): Internal.HorizontalAlignment;
        static parse(element: Internal.Element_): Internal.HorizontalAlignment;
        static values(): Internal.HorizontalAlignment[];
        static readonly LEFT: Internal.HorizontalAlignment;
        static readonly RIGHT: Internal.HorizontalAlignment;
        static readonly CENTER: Internal.HorizontalAlignment;
    }
    type HorizontalAlignment_ = "center" | "right" | HorizontalAlignment | "left";
    class ClientboundCommandsPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.RootCommandNode_<Internal.SharedSuggestionProvider>)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getRoot($$0: Internal.CommandBuildContext_): Internal.RootCommandNode<Internal.SharedSuggestionProvider>;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ClientboundCommandsPacket_ = ClientboundCommandsPacket;
    interface ChronoLocalDateTime <D extends Internal.ChronoLocalDate> extends Internal.Comparable<Internal.ChronoLocalDateTime<any>>, Internal.Temporal, Internal.TemporalAdjuster {
        plus(arg0: Internal.TemporalAmount_): this;
        abstract toLocalTime(): Internal.LocalTime;
        abstract plus(arg0: number, arg1: Internal.TemporalUnit_): this;
        compareTo(arg0: any): number;
        "with"(arg0: Internal.TemporalAdjuster_): Internal.Temporal;
        abstract getLong(arg0: Internal.TemporalField_): number;
        "with"(arg0: Internal.TemporalField_, arg1: number): Internal.Temporal;
        abstract isSupported(arg0: Internal.TemporalField_): boolean;
        format(arg0: Internal.DateTimeFormatter_): string;
        getChronology(): Internal.Chronology;
        minus(arg0: number, arg1: Internal.TemporalUnit_): this;
        isEqual(arg0: Internal.ChronoLocalDateTime_<any>): boolean;
        abstract toString(): string;
        adjustInto(arg0: Internal.Temporal_): Internal.Temporal;
        isBefore(arg0: Internal.ChronoLocalDateTime_<any>): boolean;
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        toInstant(arg0: Internal.ZoneOffset_): Internal.Instant;
        minus(arg0: Internal.TemporalAmount_): this;
        abstract until(arg0: Internal.Temporal_, arg1: Internal.TemporalUnit_): number;
        from(arg0: Internal.TemporalAccessor_): Internal.ChronoLocalDateTime<any>;
        isSupported(arg0: Internal.TemporalUnit_): boolean;
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        abstract hashCode(): number;
        isAfter(arg0: Internal.ChronoLocalDateTime_<any>): boolean;
        get(arg0: Internal.TemporalField_): number;
        abstract atZone(arg0: Internal.ZoneId_): Internal.ChronoZonedDateTime<D>;
        toEpochSecond(arg0: Internal.ZoneOffset_): number;
        abstract equals(arg0: any): boolean;
        compareTo(arg0: Internal.ChronoLocalDateTime_<any>): number;
        abstract toLocalDate(): D;
        timeLineOrder(): Internal.Comparator<Internal.ChronoLocalDateTime<any>>;
        get chronology(): Internal.Chronology
    }
    type ChronoLocalDateTime_<D extends Internal.ChronoLocalDate> = ChronoLocalDateTime<D>;
    class MelonJuiceItem extends Internal.DrinkableItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type MelonJuiceItem_ = MelonJuiceItem;
    interface TransactionContext {
        abstract addCloseCallback(arg0: Internal.TransactionContext$CloseCallback_): void;
        abstract nestingDepth(): number;
        abstract addOuterCloseCallback(arg0: Internal.TransactionContext$OuterCloseCallback_): void;
        abstract getOpenTransaction(arg0: number): Internal.Transaction;
        abstract openNested(): Internal.Transaction;
    }
    type TransactionContext_ = TransactionContext;
    class BowlFoodItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BowlFoodItem_ = BowlFoodItem;
    class HugeMushroomFeatureConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: Internal.BlockStateProvider_, $$1: Internal.BlockStateProvider_, $$2: number)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        readonly capProvider: Internal.BlockStateProvider;
        static readonly CODEC: Internal.Codec<Internal.HugeMushroomFeatureConfiguration>;
        readonly stemProvider: Internal.BlockStateProvider;
        readonly foliageRadius: number;
    }
    type HugeMushroomFeatureConfiguration_ = HugeMushroomFeatureConfiguration;
    class StairBlockBuilder extends Internal.ShapedBlockBuilder {
        constructor(i: ResourceLocation_)
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        createObject(): any;
    }
    type StairBlockBuilder_ = StairBlockBuilder;
    class EnderDragonPhaseManager {
        constructor($$0: Internal.EnderDragon_)
        getCurrentPhase(): Internal.DragonPhaseInstance;
        getPhase<T extends Internal.DragonPhaseInstance>($$0: Internal.EnderDragonPhase_<T>): T;
        setPhase($$0: Internal.EnderDragonPhase_<any>): void;
        get currentPhase(): Internal.DragonPhaseInstance
        set phase($$0: Internal.EnderDragonPhase_<any>)
    }
    type EnderDragonPhaseManager_ = EnderDragonPhaseManager;
    class TintedGlassBlock extends Internal.AbstractGlassBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type TintedGlassBlock_ = TintedGlassBlock;
    class BooleanIota extends Internal.Iota {
        constructor(d: boolean)
        toleratesOther(that: Internal.Iota_): boolean;
        static display(b: boolean): net.minecraft.network.chat.Component;
        getBool(): boolean;
        static deserialize(tag: Internal.Tag_): Internal.BooleanIota;
        get bool(): boolean
        static TYPE: Internal.BooleanIota$1;
    }
    type BooleanIota_ = BooleanIota;
    class LightSourceSettingEntry extends Internal.BooleanSettingEntry {
        constructor(key: string, guiKey: string, defaultValue: boolean, config: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config_, tooltip: net.minecraft.network.chat.Component_)
        withOnSet(arg0: Internal.Consumer_<any>): Internal.SettingEntry<any>;
    }
    type LightSourceSettingEntry_ = LightSourceSettingEntry;
    class BlockExPatternProvider extends Internal.BlockBaseGui<Internal.TileExPatternProvider> {
        constructor()
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        openGui(tile: Internal.TileExPatternProvider_, p: Internal.Player_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setSide(level: Internal.Level_, pos: BlockPos_, facing: Internal.Direction_): void;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        check(tile: Internal.TileExPatternProvider_, stack: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, hit: Internal.BlockHitResult_, p: Internal.Player_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockExPatternProvider_ = BlockExPatternProvider;
    class ClientContraption {
        constructor(contraption: Internal.Contraption_)
        resetRenderLevel(): void;
        invalidateStructure(): void;
        structureVersion(): number;
        getAndAdjustShouldRenderBlockEntities(): Internal.BitSet;
        invalidateChildren(): void;
        getBlockEntity(localPos: BlockPos_): Internal.BlockEntity;
        getMatrices(): Internal.ContraptionMatrices;
        childrenVersion(): number;
        readBlockEntity(level: Internal.Level_, info: Internal.StructureTemplate$StructureBlockInfo_, legacy: boolean): Internal.BlockEntity;
        getRenderedBlocks(): Internal.ClientContraption$RenderedBlocks;
        getRenderLevel(): Internal.VirtualRenderWorld;
        get andAdjustShouldRenderBlockEntities(): Internal.BitSet
        get matrices(): Internal.ContraptionMatrices
        get renderedBlocks(): Internal.ClientContraption$RenderedBlocks
        get renderLevel(): Internal.VirtualRenderWorld
        readonly shouldRenderBlockEntities: Internal.BitSet;
        readonly scratchErroredBlockEntities: Internal.BitSet;
        readonly renderedBlockEntityView: Internal.List<Internal.BlockEntity>;
    }
    type ClientContraption_ = ClientContraption;
    class EventResult {
        type(): Internal.EventResult$Type;
        arch(): dev.architectury.event.EventResult;
        pass(): boolean;
        interruptFalse(): boolean;
        value(): any;
        interruptDefault(): boolean;
        error(): boolean;
        override(): boolean;
        archCompound<T>(): Internal.CompoundEventResult<T>;
        interruptTrue(): boolean;
        static readonly PASS: Internal.EventResult;
    }
    type EventResult_ = EventResult;
    interface SingleRedirectModifier <S> {
        abstract apply(arg0: Internal.CommandContext_<S>): S;
        (arg0: Internal.CommandContext<S>): S;
    }
    type SingleRedirectModifier_<S> = SingleRedirectModifier<S>;
    interface MetricsObserver {
        discard(): this;
        abstract observe(arg0: Internal.Metric$Event_, arg1: number): void;
        abstract observe(arg0: Internal.Metric$Counter_): void;
    }
    type MetricsObserver_ = MetricsObserver;
    class TrackCouplerBlockItem extends Internal.TrackTargetingBlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_, type: Internal.EdgePointType_<any>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static ofType<T extends Internal.Block>(type: Internal.EdgePointType_<any>): Internal.NonNullBiFunction<T, Internal.Item$Properties, Internal.TrackTargetingBlockItem>;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type TrackCouplerBlockItem_ = TrackCouplerBlockItem;
    interface PositionSourceType <T extends Internal.PositionSource> {
        register<S extends Internal.PositionSourceType<T>, T extends Internal.PositionSource>($$0: string, $$1: S): S;
        toNetwork<T extends Internal.PositionSource>($$0: T, $$1: Internal.FriendlyByteBuf_): void;
        abstract codec(): Internal.Codec<T>;
        fromNetwork($$0: Internal.FriendlyByteBuf_): Internal.PositionSource;
        abstract read(arg0: Internal.FriendlyByteBuf_): T;
        abstract write(arg0: Internal.FriendlyByteBuf_, arg1: T): void;
        readonly BLOCK: Internal.BlockPositionSource$Type;
        readonly ENTITY: Internal.EntityPositionSource$Type;
    }
    type PositionSourceType_<T extends Internal.PositionSource> = PositionSourceType<T> | Special.PositionSourceType;
    interface AbstractContainerScreenAccessor {
        abstract getIsQuickCrafting(): boolean;
        abstract setIsQuickCrafting(arg0: boolean): void;
        abstract setSkipNextRelease(arg0: boolean): void;
        abstract invokeFindSlot(arg0: number, arg1: number): Internal.Slot;
        abstract invokeSlotClicked(arg0: Internal.Slot_, arg1: number, arg2: number, arg3: Internal.ClickType_): void;
        abstract getQuickCraftingButton(): number;
        get isQuickCrafting(): boolean
        set isQuickCrafting(arg0: boolean)
        set skipNextRelease(arg0: boolean)
        get quickCraftingButton(): number
    }
    type AbstractContainerScreenAccessor_ = AbstractContainerScreenAccessor;
    class BrewingStandMenu extends Internal.AbstractContainerMenu {
        constructor($$0: number, $$1: Internal.Inventory_, $$2: net.minecraft.world.Container_, $$3: Internal.ContainerData_)
        constructor($$0: number, $$1: Internal.Inventory_)
        getBrewingTicks(): number;
        getFuel(): number;
        get brewingTicks(): number
        get fuel(): number
    }
    type BrewingStandMenu_ = BrewingStandMenu;
    interface TypeFamily {
        familyOptic<A, B>(arg0: Internal.IntFunction_<Internal.TypedOptic<any, any, A, B>>): Internal.FamilyOptic<A, B>;
        abstract apply(arg0: number): com.mojang.datafixers.types.Type<any>;
        (arg0: number): com.mojang.datafixers.types.Type_<any>;
    }
    type TypeFamily_ = TypeFamily;
    interface ModifiableItemKJS {
        kjs$getAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        kjs$setAttributeMap(attributes: Internal.Multimap_<Internal.Attribute, Internal.AttributeModifier>): void;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
    }
    type ModifiableItemKJS_ = ModifiableItemKJS;
    class EjectorItem extends Internal.BlockItem {
        constructor(p_i48527_1_: Internal.Block_, p_i48527_2_: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type EjectorItem_ = EjectorItem;
    interface DiscreteVoxelShape$IntLineConsumer {
        abstract consume(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): void;
        (arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): void;
    }
    type DiscreteVoxelShape$IntLineConsumer_ = DiscreteVoxelShape$IntLineConsumer;
    class CartAssembleRailType extends Internal.Enum<Internal.CartAssembleRailType> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.CartAssembleRailType[];
        getSerializedName(): string;
        getItem(): Internal.Item;
        static valueOf(name: string): Internal.CartAssembleRailType;
        getBlock(): Internal.Block;
        matches(rail: Internal.BlockState_): boolean;
        get serializedName(): string
        get item(): Internal.Item
        get block(): Internal.Block
        static readonly DETECTOR_RAIL: Internal.CartAssembleRailType;
        static readonly ACTIVATOR_RAIL: Internal.CartAssembleRailType;
        static readonly POWERED_RAIL: Internal.CartAssembleRailType;
        static readonly REGULAR: Internal.CartAssembleRailType;
        static readonly CONTROLLER_RAIL: Internal.CartAssembleRailType;
    }
    type CartAssembleRailType_ = "regular" | "powered_rail" | "activator_rail" | CartAssembleRailType | "controller_rail" | "detector_rail";
    abstract class PackagePortBlockEntity extends Internal.SmartBlockEntity implements Internal.SidedStorageBlockEntity, Internal.MenuProvider {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        filterChanged(): void;
        getComparatorOutput(): number;
        getFluidStorage(side: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        createMenu(pContainerId: number, pPlayerInventory: Internal.Inventory_, pPlayer: Internal.Player_): Internal.AbstractContainerMenu;
        shouldCloseCurrentScreen(): boolean;
        onLoad(): void;
        getItemStorage(side: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        getFilterString(): string;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        drop(box: Internal.ItemStack_): void;
        isBackedUp(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        use(player: Internal.Player_): Internal.InteractionResult;
        get displayName(): net.minecraft.network.chat.Component
        get comparatorOutput(): number
        get infiniteBoundingBox(): Internal.AABB
        get filterString(): string
        get backedUp(): boolean
        acceptsPackages: boolean;
        addressFilter: string;
        target: Internal.PackagePortTarget;
        inventory: Internal.SmartInventory;
    }
    type PackagePortBlockEntity_ = PackagePortBlockEntity;
    interface ScaleEventCallback {
        abstract onEvent(arg0: Internal.ScaleData_): void;
        (arg0: Internal.ScaleData): void;
    }
    type ScaleEventCallback_ = ScaleEventCallback;
    /**
     * @deprecated
    */
    class StringRepresentable$EnumCodec <E extends Internal.Enum<E> & Internal.StringRepresentable> implements Internal.Codec<E> {
        constructor($$0: E[], $$1: Internal.Function_<string, E>)
        parse<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<E>;
        static empty<A>(): Internal.MapEncoder<A>;
        flatComap<B>(arg0: Internal.Function_<B, Internal.DataResult<E>>): Internal.Encoder<B>;
        optionalFieldOf(arg0: string, arg1: E): Internal.MapCodec<E>;
        static error<A>(arg0: string): Internal.Encoder<A>;
        static unit<A>(arg0: Internal.Supplier_<A>): Internal.Codec<A>;
        static floatRange(arg0: number, arg1: number): Internal.Codec<number>;
        simple(): Internal.Decoder$Simple<E>;
        dispatch<E>(arg0: Internal.Function_<E, E>, arg1: Internal.Function_<E, Internal.Codec<E>>): Internal.Codec<E>;
        xmap<S>(arg0: Internal.Function_<E, S>, arg1: Internal.Function_<S, E>): Internal.Codec<S>;
        static ofBoxed<A>(arg0: Internal.Decoder$Boxed_<A>): Internal.Decoder<A>;
        dispatchMap<E>(arg0: string, arg1: Internal.Function_<E, E>, arg2: Internal.Function_<E, Internal.Codec<E>>): Internal.MapCodec<E>;
        dispatch<E>(arg0: string, arg1: Internal.Function_<E, E>, arg2: Internal.Function_<E, Internal.Codec<E>>): Internal.Codec<E>;
        comap<B>(arg0: Internal.Function_<B, E>): Internal.Encoder<B>;
        stable(): Internal.Codec<E>;
        static unit<A>(arg0: A): Internal.Codec<A>;
        static intRange(arg0: number, arg1: number): Internal.Codec<number>;
        orElseGet(arg0: Internal.Consumer_<string>, arg1: Internal.Supplier_<E>): Internal.Codec<E>;
        withLifecycle(arg0: Internal.Lifecycle_): Internal.Codec<E>;
        static pair<F, S>(arg0: Internal.Codec_<F>, arg1: Internal.Codec_<S>): Internal.Codec<com.mojang.datafixers.util.Pair<F, S>>;
        promotePartial(arg0: Internal.Consumer_<string>): Internal.Codec<E>;
        comapFlatMap<S>(arg0: Internal.Function_<E, Internal.DataResult<S>>, arg1: Internal.Function_<S, E>): Internal.Codec<S>;
        static either<F, S>(arg0: Internal.Codec_<F>, arg1: Internal.Codec_<S>): Internal.Codec<Internal.Either<F, S>>;
        static checkRange<N extends number & Internal.Comparable<N>>(arg0: N, arg1: N): Internal.Function<N, Internal.DataResult<N>>;
        orElse(arg0: Internal.UnaryOperator_<string>, arg1: E): Internal.Codec<E>;
        dispatchStable<E>(arg0: Internal.Function_<E, E>, arg1: Internal.Function_<E, Internal.Codec<E>>): Internal.Codec<E>;
        static unboundedMap<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>): Internal.UnboundedMapCodec<K, V>;
        optionalFieldOf(arg0: string): Internal.MapCodec<Internal.Optional<E>>;
        fieldOf(arg0: string): Internal.MapDecoder<any>;
        parse<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<E>;
        optionalFieldOf(arg0: string, arg1: Internal.Lifecycle_, arg2: E, arg3: Internal.Lifecycle_): Internal.MapCodec<E>;
        static of<A>(arg0: Internal.Encoder_<A>, arg1: Internal.Decoder_<A>, arg2: string): Internal.Codec<A>;
        flatComapMap<S>(arg0: Internal.Function_<E, S>, arg1: Internal.Function_<S, Internal.DataResult<E>>): Internal.Codec<S>;
        map<B>(arg0: Internal.Function_<E, B>): Internal.Decoder<B>;
        static ofSimple<A>(arg0: Internal.Decoder$Simple_<A>): Internal.Decoder<A>;
        static mapEither<F, S>(arg0: Internal.MapCodec_<F>, arg1: Internal.MapCodec_<S>): Internal.MapCodec<Internal.Either<F, S>>;
        static doubleRange(arg0: number, arg1: number): Internal.Codec<number>;
        flatXmap<S>(arg0: Internal.Function_<E, Internal.DataResult<S>>, arg1: Internal.Function_<S, Internal.DataResult<E>>): Internal.Codec<S>;
        static optionalField<F>(arg0: string, arg1: Internal.Codec_<F>): Internal.MapCodec<Internal.Optional<F>>;
        static simpleMap<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>, arg2: Internal.Keyable_): Internal.SimpleMapCodec<K, V>;
        orElseGet(arg0: Internal.Supplier_<E>): Internal.Codec<E>;
        listOf(): Internal.Codec<Internal.List<E>>;
        static ofTerminal<A>(arg0: Internal.Decoder$Terminal_<A>): Internal.Decoder<A>;
        encode(arg0: any, arg1: Internal.DynamicOps_<any>, arg2: any): Internal.DataResult<any>;
        static list<E>(arg0: Internal.Codec_<E>): Internal.Codec<Internal.List<E>>;
        byName($$0: string, $$1: E): E;
        boxed(): Internal.Decoder$Boxed<E>;
        deprecated(arg0: number): Internal.Codec<E>;
        static of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>): Internal.MapCodec<A>;
        dispatchMap<E>(arg0: Internal.Function_<E, E>, arg1: Internal.Function_<E, Internal.Codec<E>>): Internal.MapCodec<E>;
        static of<A>(arg0: Internal.Encoder_<A>, arg1: Internal.Decoder_<A>): Internal.Codec<A>;
        orElse(arg0: Internal.Consumer_<string>, arg1: E): Internal.Codec<E>;
        partialDispatch<E>(arg0: string, arg1: Internal.Function_<E, Internal.DataResult<E>>, arg2: Internal.Function_<E, Internal.DataResult<Internal.Codec<E>>>): Internal.Codec<E>;
        terminal(): Internal.Decoder$Terminal<E>;
        decode<T>($$0: Internal.DynamicOps_<T>, $$1: T): Internal.DataResult<com.mojang.datafixers.util.Pair<E, T>>;
        orElseGet(arg0: Internal.UnaryOperator_<string>, arg1: Internal.Supplier_<E>): Internal.Codec<E>;
        optionalFieldOf(arg0: string, arg1: E, arg2: Internal.Lifecycle_): Internal.MapCodec<E>;
        flatMap<B>(arg0: Internal.Function_<E, Internal.DataResult<B>>): Internal.Decoder<B>;
        static of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>, arg2: Internal.Supplier_<string>): Internal.MapCodec<A>;
        static compoundList<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>): Internal.Codec<Internal.List<com.mojang.datafixers.util.Pair<K, V>>>;
        byName($$0: string): E;
        decode<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<com.mojang.datafixers.util.Pair<E, T>>;
        orElse(arg0: E): Internal.Codec<E>;
        mapResult(arg0: Internal.Codec$ResultFunction_<E>): Internal.Codec<E>;
        static mapPair<F, S>(arg0: Internal.MapCodec_<F>, arg1: Internal.MapCodec_<S>): Internal.MapCodec<com.mojang.datafixers.util.Pair<F, S>>;
        encodeStart<T>(arg0: Internal.DynamicOps_<T>, arg1: E): Internal.DataResult<T>;
        encode<T>($$0: E, $$1: Internal.DynamicOps_<T>, $$2: T): Internal.DataResult<T>;
    }
    type StringRepresentable$EnumCodec_<E extends Internal.Enum<E> & Internal.StringRepresentable> = StringRepresentable$EnumCodec<E>;
    class EntitySection <T extends Internal.EntityAccess> implements Internal.EntityMovementTrackerSection, Internal.EntityTrackingSectionAccessor<any>, Internal.ClimbingMobCachingSection, Internal.PositionedEntityTrackingSection, me.jellysquid.mods.lithium.mixin.block.hopper.EntityTrackingSectionAccessor<any> {
        constructor($$0: T, $$1: Internal.Visibility_)
        getEntities<U extends T>($$0: Internal.EntityTypeTest_<T, U>, $$1: Internal.AABB_, $$2: Internal.AbortableIterationConsumer_<U>): Internal.AbortableIterationConsumer$Continuation;
        getCollection(): Internal.ClassInstanceMultiMap<any>;
        removeListener(sectionedEntityCache: Internal.EntitySectionStorage_<any>, listener: Internal.SectionedEntityMovementTracker_<any, any>): void;
        setPos(chunkSectionPos: number): void;
        getEntities($$0: Internal.AABB_, $$1: Internal.AbortableIterationConsumer_<T>): Internal.AbortableIterationConsumer$Continuation;
        trackEntityMovement(notificationMask: number, time: number): void;
        listenToMovementOnce(listener: Internal.SectionedEntityMovementTracker_<any, any>, trackedClass: number): void;
        getStatus(): Internal.Visibility;
        isEmpty(): boolean;
        onEntityModifiedCachedBlock(entity: Internal.BlockCachingEntity_, newBlockState: Internal.BlockState_): void;
        getEntities(): Internal.Stream<T>;
        getChangeTime(trackedClass: number): number;
        addListener(listener: Internal.SectionedEntityMovementTracker_<any, any>): void;
        size(): number;
        localvar$elb000$lithium$swapStatus(newStatus: Internal.Visibility_): Internal.Visibility;
        remove($$0: T): boolean;
        handler$elb000$lithium$isEmpty(cir: Internal.CallbackInfoReturnable_<any>): void;
        removeListenToMovementOnce(listener: Internal.SectionedEntityMovementTracker_<any, any>, trackedClass: number): void;
        collectPushableEntities(world: Internal.Level_, except: Internal.Entity_, box: Internal.AABB_, entityPushablePredicate: Internal.EntityPushablePredicate_<any>, entities: Internal.ArrayList_<any>): Internal.AbortableIterationConsumer$Continuation;
        getPos(): number;
        add($$0: T): void;
        updateChunkStatus($$0: Internal.Visibility_): Internal.Visibility;
        get collection(): Internal.ClassInstanceMultiMap<any>
        set pos(chunkSectionPos: number)
        get status(): Internal.Visibility
        get empty(): boolean
        get entities(): Internal.Stream<T>
        get pos(): number
    }
    type EntitySection_<T extends Internal.EntityAccess> = EntitySection<T>;
    class NetherWorldCarver extends Internal.CaveWorldCarver {
        constructor($$0: Internal.Codec_<Internal.CaveCarverConfiguration>)
    }
    type NetherWorldCarver_ = NetherWorldCarver;
    class GlyphMetrics {
        constructor(arg0: boolean, arg1: number, arg2: number, arg3: Internal.Rectangle2D_, arg4: number)
        constructor(arg0: number, arg1: Internal.Rectangle2D_, arg2: number)
        getType(): number;
        isComponent(): boolean;
        getAdvance(): number;
        getLSB(): number;
        getAdvanceY(): number;
        isCombining(): boolean;
        getAdvanceX(): number;
        isStandard(): boolean;
        getBounds2D(): Internal.Rectangle2D;
        isLigature(): boolean;
        isWhitespace(): boolean;
        getRSB(): number;
        get type(): number
        get component(): boolean
        get advance(): number
        get LSB(): number
        get advanceY(): number
        get combining(): boolean
        get advanceX(): number
        get standard(): boolean
        get bounds2D(): Internal.Rectangle2D
        get ligature(): boolean
        get whitespace(): boolean
        get RSB(): number
        static readonly WHITESPACE: 4;
        static readonly STANDARD: 0;
        static readonly COMBINING: 2;
        static readonly COMPONENT: 3;
        static readonly LIGATURE: 1;
    }
    type GlyphMetrics_ = GlyphMetrics;
    class CookingUpgradeWrapper$SmeltingUpgradeWrapper extends Internal.CookingUpgradeWrapper<Internal.CookingUpgradeWrapper$SmeltingUpgradeWrapper, Internal.SmeltingUpgradeItem, Internal.SmeltingRecipe> {
        constructor(storageWrapper: Internal.IStorageWrapper_, upgrade: Internal.ItemStack_, upgradeSaveHandler: Internal.Consumer_<Internal.ItemStack>)
        canBeDisabled(): boolean;
        hideSettingsTab(): boolean;
        onAdded(): void;
    }
    type CookingUpgradeWrapper$SmeltingUpgradeWrapper_ = CookingUpgradeWrapper$SmeltingUpgradeWrapper;
    class Difficulty extends Internal.Enum<Internal.Difficulty> implements Internal.StringRepresentable {
        static values(): Internal.Difficulty[];
        getDisplayName(): net.minecraft.network.chat.Component;
        static byId($$0: number): Internal.Difficulty;
        static byName($$0: string): Internal.Difficulty;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getKey(): string;
        getSerializedName(): string;
        static valueOf($$0: string): Internal.Difficulty;
        getInfo(): net.minecraft.network.chat.Component;
        getId(): number;
        get displayName(): net.minecraft.network.chat.Component
        get key(): string
        get serializedName(): string
        get info(): net.minecraft.network.chat.Component
        get id(): number
        static readonly NORMAL: Internal.Difficulty;
        static readonly PEACEFUL: Internal.Difficulty;
        static readonly HARD: Internal.Difficulty;
        static readonly EASY: Internal.Difficulty;
        static readonly CODEC: Internal.StringRepresentable$EnumCodec<Internal.Difficulty>;
    }
    type Difficulty_ = "normal" | "peaceful" | Difficulty | "hard" | "easy";
    class NavigationDirection extends Internal.Enum<Internal.NavigationDirection> {
        static valueOf(name: string): Internal.NavigationDirection;
        isVertical(): boolean;
        static fromKey(keyCode: number, shift: boolean): Internal.Optional<Internal.NavigationDirection>;
        isLookingForward(): boolean;
        static values(): Internal.NavigationDirection[];
        isHorizontal(): boolean;
        get vertical(): boolean
        get lookingForward(): boolean
        get horizontal(): boolean
        static readonly RIGHT: Internal.NavigationDirection;
        static readonly LEFT: Internal.NavigationDirection;
        static readonly DOWN: Internal.NavigationDirection;
        static readonly UP: Internal.NavigationDirection;
    }
    type NavigationDirection_ = "up" | "down" | NavigationDirection | "right" | "left";
    class OptionInstance$Enum <T> extends Internal.Record implements Internal.OptionInstance$CycleableValueSet<T> {
        constructor($$0: Internal.List_<T>, $$1: Internal.Codec_<T>)
        values(): Internal.List<T>;
        validateValue($$0: T): Internal.Optional<T>;
        codec(): Internal.Codec<T>;
        createButton($$0: Internal.OptionInstance$TooltipSupplier_<T>, $$1: Internal.Options_, $$2: number, $$3: number, $$4: number, $$5: Internal.Consumer_<T>): Internal.Function<Internal.OptionInstance<T>, Internal.AbstractWidget>;
        valueSetter(): Internal.OptionInstance$CycleableValueSet$ValueSetter<T>;
        valueListSupplier(): Internal.CycleButton$ValueListSupplier<T>;
    }
    type OptionInstance$Enum_<T> = OptionInstance$Enum<T>;
    class ItemTransforms {
        constructor($$0: Internal.ItemTransform_, $$1: Internal.ItemTransform_, $$2: Internal.ItemTransform_, $$3: Internal.ItemTransform_, $$4: Internal.ItemTransform_, $$5: Internal.ItemTransform_, $$6: Internal.ItemTransform_, $$7: Internal.ItemTransform_)
        constructor($$0: Internal.ItemTransforms_)
        hasTransform($$0: Internal.ItemDisplayContext_): boolean;
        getTransform($$0: Internal.ItemDisplayContext_): Internal.ItemTransform;
        readonly fixed: Internal.ItemTransform;
        readonly thirdPersonRightHand: Internal.ItemTransform;
        static readonly NO_TRANSFORMS: Internal.ItemTransforms;
        readonly thirdPersonLeftHand: Internal.ItemTransform;
        readonly firstPersonLeftHand: Internal.ItemTransform;
        readonly head: Internal.ItemTransform;
        readonly ground: Internal.ItemTransform;
        readonly firstPersonRightHand: Internal.ItemTransform;
        readonly gui: Internal.ItemTransform;
    }
    type ItemTransforms_ = ItemTransforms;
    abstract class RenderType extends Internal.RenderStateShard implements net.createmod.ponder.mixin.client.accessor.RenderTypeAccessor, io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.RenderTypeAccessor, Internal.AccessorRenderType, net.irisshaders.batchedentityrendering.mixin.RenderTypeAccessor, Internal.RenderTypeAccessor, Internal.BlendingStateHolder {
        constructor($$0: string, $$1: Internal.VertexFormat_, $$2: Internal.VertexFormat$Mode_, $$3: number, $$4: boolean, $$5: boolean, $$6: Internal.Runnable_, $$7: Internal.Runnable_)
        static cutout(): Internal.RenderType;
        static entityTranslucentEmissive($$0: ResourceLocation_): Internal.RenderType;
        static beaconBeam($$0: ResourceLocation_, $$1: boolean): Internal.RenderType;
        static textIntensitySeeThrough($$0: ResourceLocation_): Internal.RenderType;
        static entitySolid($$0: ResourceLocation_): Internal.RenderType;
        affectsCrumbling(): boolean;
        static getGLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        outline(): Internal.Optional<Internal.RenderType>;
        setTransparencyType(transparencyType: Internal.TransparencyType_): void;
        static textBackgroundSeeThrough(): Internal.RenderType;
        static lines(): Internal.RenderType;
        static entityTranslucent($$0: ResourceLocation_): Internal.RenderType;
        static entityCutout($$0: ResourceLocation_): Internal.RenderType;
        static entityNoOutline($$0: ResourceLocation_): Internal.RenderType;
        static entityShadow($$0: ResourceLocation_): Internal.RenderType;
        static tripwire(): Internal.RenderType;
        static entityCutoutNoCull($$0: ResourceLocation_): Internal.RenderType;
        static translucentNoCrumbling(): Internal.RenderType;
        static entityGlint(): Internal.RenderType;
        static debugFilledBox(): Internal.RenderType;
        static guiOverlay(): Internal.RenderType;
        static energySwirl($$0: ResourceLocation_, $$1: number, $$2: number): Internal.RenderType;
        getTransparencyType(): Internal.TransparencyType;
        static text($$0: ResourceLocation_): Internal.RenderType;
        static outline($$0: ResourceLocation_): Internal.RenderType;
        static textBackground(): Internal.RenderType;
        mode(): Internal.VertexFormat$Mode;
        static endPortal(): Internal.RenderType;
        static guiTextHighlight(): Internal.RenderType;
        static port_lib$create(string: string, vertexFormat: Internal.VertexFormat_, mode: Internal.VertexFormat$Mode_, i: number, bl: boolean, bl2: boolean, compositeState: Internal.RenderType$CompositeState_): Internal.RenderType$CompositeRenderType;
        static leash(): Internal.RenderType;
        static glintTranslucent(): Internal.RenderType;
        static catnip$create(string: string, vertexFormat: Internal.VertexFormat_, mode: Internal.VertexFormat$Mode_, i: number, bl: boolean, bl2: boolean, compositeState: Internal.RenderType$CompositeState_): Internal.RenderType$CompositeRenderType;
        static catnip$create$ponder_$md$fca01f$2(arg0: string, arg1: Internal.VertexFormat_, arg2: Internal.VertexFormat$Mode_, arg3: number, arg4: boolean, arg5: boolean, arg6: Internal.RenderType$CompositeState_): Internal.RenderType$CompositeRenderType;
        static create($$0: string, $$1: Internal.VertexFormat_, $$2: Internal.VertexFormat$Mode_, $$3: number, $$4: Internal.RenderType$CompositeState_): Internal.RenderType$CompositeRenderType;
        static entityCutoutNoCull($$0: ResourceLocation_, $$1: boolean): Internal.RenderType;
        static translucentMovingBlock(): Internal.RenderType;
        static itemEntityTranslucentCull($$0: ResourceLocation_): Internal.RenderType;
        static armorCutoutNoCull($$0: ResourceLocation_): Internal.RenderType;
        static armorGlint(): Internal.RenderType;
        static debugLineStrip($$0: number): Internal.RenderType;
        end($$0: Internal.BufferBuilder_, $$1: Internal.VertexSorting_): void;
        isOutline(): boolean;
        static glintDirect(): Internal.RenderType;
        static entityGlintDirect(): Internal.RenderType;
        static eyes($$0: ResourceLocation_): Internal.RenderType;
        static debugSectionQuads(): Internal.RenderType;
        static getCRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static entityCutoutNoCullZOffset($$0: ResourceLocation_, $$1: boolean): Internal.RenderType;
        static hex$create$hexcasting_$md$fca01f$1(arg0: string, arg1: Internal.VertexFormat_, arg2: Internal.VertexFormat$Mode_, arg3: number, arg4: boolean, arg5: boolean, arg6: Internal.RenderType$CompositeState_): Internal.RenderType$CompositeRenderType;
        bufferSize(): number;
        static textSeeThrough($$0: ResourceLocation_): Internal.RenderType;
        static entityTranslucent($$0: ResourceLocation_, $$1: boolean): Internal.RenderType;
        static create($$0: string, $$1: Internal.VertexFormat_, $$2: Internal.VertexFormat$Mode_, $$3: number, $$4: boolean, $$5: boolean, $$6: Internal.RenderType$CompositeState_): Internal.RenderType$CompositeRenderType;
        static entitySmoothCutout($$0: ResourceLocation_): Internal.RenderType;
        static getTranslucentTransparency(): Internal.RenderStateShard$TransparencyStateShard;
        static solid(): Internal.RenderType;
        static dragonExplosionAlpha($$0: ResourceLocation_): Internal.RenderType;
        static getNO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static endGateway(): Internal.RenderType;
        shouldSortOnUpload(): boolean;
        static textIntensity($$0: ResourceLocation_): Internal.RenderType;
        static entityTranslucentEmissive($$0: ResourceLocation_, $$1: boolean): Internal.RenderType;
        static glint(): Internal.RenderType;
        format(): Internal.VertexFormat;
        canConsolidateConsecutiveGeometry(): boolean;
        static waterMask(): Internal.RenderType;
        static gui(): Internal.RenderType;
        static entityCutoutNoCullZOffset($$0: ResourceLocation_): Internal.RenderType;
        static chunkBufferLayers(): Internal.List<Internal.RenderType>;
        static lineStrip(): Internal.RenderType;
        static debugQuads(): Internal.RenderType;
        static textPolygonOffset($$0: ResourceLocation_): Internal.RenderType;
        static port_lib$create$porting_lib_accessors_$md$fca01f$0(arg0: string, arg1: Internal.VertexFormat_, arg2: Internal.VertexFormat$Mode_, arg3: number, arg4: boolean, arg5: boolean, arg6: Internal.RenderType$CompositeState_): Internal.RenderType$CompositeRenderType;
        static crumbling($$0: ResourceLocation_): Internal.RenderType;
        static guiGhostRecipeOverlay(): Internal.RenderType;
        static entityDecal($$0: ResourceLocation_): Internal.RenderType;
        static armorEntityGlint(): Internal.RenderType;
        static cutoutMipped(): Internal.RenderType;
        asOptional(): Internal.Optional<Internal.RenderType>;
        static lightning(): Internal.RenderType;
        static hex$create(string: string, vertexFormat: Internal.VertexFormat_, mode: Internal.VertexFormat$Mode_, bufSize: number, hasCrumbling: boolean, sortOnUpload: boolean, compositeState: Internal.RenderType$CompositeState_): Internal.RenderType$CompositeRenderType;
        static translucent(): Internal.RenderType;
        static translucentState($$0: Internal.RenderStateShard$ShaderStateShard_): Internal.RenderType$CompositeState;
        static entityTranslucentCull($$0: ResourceLocation_): Internal.RenderType;
        static textIntensityPolygonOffset($$0: ResourceLocation_): Internal.RenderType;
        get GLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        set transparencyType(transparencyType: Internal.TransparencyType_)
        get transparencyType(): Internal.TransparencyType
        get outline(): boolean
        get CRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get translucentTransparency(): Internal.RenderStateShard$TransparencyStateShard
        get NO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        static readonly LINES: Internal.RenderType$CompositeRenderType;
        static readonly TRANSIENT_BUFFER_SIZE: 256;
        static readonly BIG_BUFFER_SIZE: 2097152;
        static readonly SMALL_BUFFER_SIZE: 131072;
        static readonly MEDIUM_BUFFER_SIZE: 262144;
        sortOnUpload: boolean;
        static readonly LINE_STRIP: Internal.RenderType$CompositeRenderType;
    }
    type RenderType_ = RenderType;
    class TooltipKey extends Internal.Enum<Internal.TooltipKey> {
        static valueOf(name: string): Internal.TooltipKey;
        isShiftOrUnknown(): boolean;
        static values(): Internal.TooltipKey[];
        get shiftOrUnknown(): boolean
        static readonly CONTROL: Internal.TooltipKey;
        static readonly ALT: Internal.TooltipKey;
        static readonly SHIFT: Internal.TooltipKey;
        static readonly NORMAL: Internal.TooltipKey;
        static readonly UNKNOWN: Internal.TooltipKey;
    }
    type TooltipKey_ = "normal" | "alt" | TooltipKey | "control" | "unknown" | "shift";
    class BlockHexDoor extends Internal.DoorBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        isFlammable(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getFireSpreadSpeed(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): number;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getFlammability(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockHexDoor_ = BlockHexDoor;
    interface TileObserver {
        abstract tileUpdate(arg0: Internal.WritableRenderedImage_, arg1: number, arg2: number, arg3: boolean): void;
        (arg0: Internal.WritableRenderedImage, arg1: number, arg2: number, arg3: boolean): void;
    }
    type TileObserver_ = TileObserver;
    class PlacedFeature extends Internal.Record {
        constructor($$0: Internal.Holder_<Internal.ConfiguredFeature<any, any>>, $$1: Internal.List_<Internal.PlacementModifier>)
        place($$0: Internal.WorldGenLevel_, $$1: Internal.ChunkGenerator_, $$2: Internal.RandomSource_, $$3: BlockPos_): boolean;
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        feature(): Internal.Holder<Internal.ConfiguredFeature<any, any>>;
        placeWithBiomeCheck($$0: Internal.WorldGenLevel_, $$1: Internal.ChunkGenerator_, $$2: Internal.RandomSource_, $$3: BlockPos_): boolean;
        placement(): Internal.List<Internal.PlacementModifier>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly LIST_CODEC: Internal.Codec<Internal.HolderSet<Internal.PlacedFeature>>;
        static readonly DIRECT_CODEC: Internal.Codec<Internal.PlacedFeature>;
        static readonly LIST_OF_LISTS_CODEC: Internal.Codec<Internal.List<Internal.HolderSet<Internal.PlacedFeature>>>;
        static readonly CODEC: Internal.Codec<Internal.Holder<Internal.PlacedFeature>>;
    }
    type PlacedFeature_ = Special.PlacedFeature | PlacedFeature;
    interface LoadedChunksCache {
        abstract fabric_markLoaded(arg0: Internal.LevelChunk_): void;
        abstract fabric_getLoadedChunks(): Internal.Set<Internal.LevelChunk>;
        abstract fabric_markUnloaded(arg0: Internal.LevelChunk_): void;
    }
    type LoadedChunksCache_ = LoadedChunksCache;
    class EarthSlimeIslandStructure extends Internal.AbstractIslandStructure {
        constructor(structureSettings: Internal.Structure$StructureSettings_)
        type(): Internal.StructureType<Internal.EarthSlimeIslandStructure>;
        static readonly CODEC: Internal.Codec<Internal.EarthSlimeIslandStructure>;
    }
    type EarthSlimeIslandStructure_ = EarthSlimeIslandStructure;
    class ConfigBase$ConfigGroup extends Internal.ConfigBase$CValue<boolean, Internal.ForgeConfigSpec$BooleanValue> {
        constructor(this$0: Internal.ConfigBase_, name: string, depth: number, ...comment: string[])
    }
    type ConfigBase$ConfigGroup_ = ConfigBase$ConfigGroup;
    class LootrInventoryBlock extends Internal.ChestBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(pLevel: Internal.Level_, pState: Internal.BlockState_, pBlockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type LootrInventoryBlock_ = LootrInventoryBlock;
    class SwappableModifierRecipe$Serializer extends Internal.AbstractModifierRecipe$Serializer<any> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_, arg2: Internal.Ingredient_, arg3: number, arg4: Internal.ModifierMatch_, arg5: string, arg6: Internal.ModifierEntry_, arg7: number, arg8: Internal.SlotType$SlotCount_): Internal.AbstractModifierRecipe;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_, arg2: Internal.Ingredient_, arg3: number, arg4: Internal.ModifierMatch_, arg5: string, arg6: Internal.ModifierEntry_, arg7: number, arg8: Internal.SlotType$SlotCount_): Internal.AbstractModifierRecipe;
    }
    type SwappableModifierRecipe$Serializer_ = SwappableModifierRecipe$Serializer;
    interface TypeDescriptor$OfMethod <F extends Internal.TypeDescriptor$OfField<F>, M extends Internal.TypeDescriptor$OfMethod<F, M>> extends Internal.TypeDescriptor {
        abstract returnType(): F;
        abstract changeParameterType(arg0: number, arg1: F): M;
        abstract descriptorString(): string;
        abstract parameterCount(): number;
        abstract parameterArray(): F[];
        abstract insertParameterTypes(arg0: number, ...arg1: F[]): M;
        abstract parameterType(arg0: number): F;
        abstract parameterList(): Internal.List<F>;
        abstract changeReturnType(arg0: F): M;
        abstract dropParameterTypes(arg0: number, arg1: number): M;
    }
    type TypeDescriptor$OfMethod_<F extends Internal.TypeDescriptor$OfField<F>, M extends Internal.TypeDescriptor$OfMethod<F, M>> = TypeDescriptor$OfMethod<F, M>;
    class PoiManager extends Internal.SectionStorage<any> implements Internal.PointOfInterestStorageExtended {
        constructor($$0: Internal.Path_, $$1: Internal.DataFixer_, $$2: boolean, $$3: Internal.RegistryAccess_, $$4: Internal.LevelHeightAccessor_)
        checkConsistencyWithBlocks($$0: Internal.SectionPos_, $$1: Internal.LevelChunkSection_): void;
        getInChunk(predicate: Internal.Predicate_<any>, pos: Internal.ChunkPos_, status: Internal.PoiManager$Occupancy_): Internal.Stream<any>;
        getCountInRange(predicate: Internal.Predicate_<any>, pos: BlockPos_, radius: number, status: Internal.PoiManager$Occupancy_): number;
        sectionsToVillage($$0: Internal.SectionPos_): number;
        findNearestForPortalLogic(origin: BlockPos_, radius: number, type: Internal.Holder_<any>, status: Internal.PoiManager$Occupancy_, afterSortPredicate: Internal.Predicate_<any>, worldBorder: Internal.WorldBorder_): Internal.Optional<any>;
        method_19290($$0: Internal.BooleanSupplier_): void;
        getInSquare($$0: Internal.Predicate_<Internal.Holder<Internal.PoiType>>, $$1: BlockPos_, $$2: number, $$3: Internal.PoiManager$Occupancy_): Internal.Stream<Internal.PoiRecord>;
        /**
         * @deprecated
        */
        getFreeTickets($$0: BlockPos_): number;
        findClosestWithType($$0: Internal.Predicate_<Internal.Holder<Internal.PoiType>>, $$1: BlockPos_, $$2: number, $$3: Internal.PoiManager$Occupancy_): Internal.Optional<com.mojang.datafixers.util.Pair<Internal.Holder<Internal.PoiType>, BlockPos>>;
        getRandom(typePredicate: Internal.Predicate_<any>, posPredicate: Internal.Predicate_<any>, status: Internal.PoiManager$Occupancy_, pos: BlockPos_, radius: number, rand: Internal.RandomSource_): Internal.Optional<any>;
        ensureLoadedAndValid(worldView: Internal.LevelReader_, pos: BlockPos_, radius: number): void;
        release($$0: BlockPos_): boolean;
        getType($$0: BlockPos_): Internal.Optional<Internal.Holder<Internal.PoiType>>;
        take($$0: Internal.Predicate_<Internal.Holder<Internal.PoiType>>, $$1: Internal.BiPredicate_<Internal.Holder<Internal.PoiType>, BlockPos>, $$2: BlockPos_, $$3: number): Internal.Optional<BlockPos>;
        findAllClosestFirstWithType($$0: Internal.Predicate_<Internal.Holder<Internal.PoiType>>, $$1: Internal.Predicate_<BlockPos>, $$2: BlockPos_, $$3: number, $$4: Internal.PoiManager$Occupancy_): Internal.Stream<com.mojang.datafixers.util.Pair<Internal.Holder<Internal.PoiType>, BlockPos>>;
        existsAtPosition($$0: Internal.ResourceKey_<Internal.PoiType>, $$1: BlockPos_): boolean;
        getInRange(predicate: Internal.Predicate_<any>, sphereOrigin: BlockPos_, radius: number, status: Internal.PoiManager$Occupancy_): Internal.Stream<any>;
        findAllWithType($$0: Internal.Predicate_<Internal.Holder<Internal.PoiType>>, $$1: Internal.Predicate_<BlockPos>, $$2: BlockPos_, $$3: number, $$4: Internal.PoiManager$Occupancy_): Internal.Stream<com.mojang.datafixers.util.Pair<Internal.Holder<Internal.PoiType>, BlockPos>>;
        exists($$0: BlockPos_, $$1: Internal.Predicate_<Internal.Holder<Internal.PoiType>>): boolean;
        find($$0: Internal.Predicate_<Internal.Holder<Internal.PoiType>>, $$1: Internal.Predicate_<BlockPos>, $$2: BlockPos_, $$3: number, $$4: Internal.PoiManager$Occupancy_): Internal.Optional<BlockPos>;
        add($$0: BlockPos_, $$1: Internal.Holder_<Internal.PoiType>): void;
        findClosest(predicate: Internal.Predicate_<any>, posPredicate: Internal.Predicate_<any>, pos: BlockPos_, radius: number, status: Internal.PoiManager$Occupancy_): Internal.Optional<any>;
        findAll($$0: Internal.Predicate_<Internal.Holder<Internal.PoiType>>, $$1: Internal.Predicate_<BlockPos>, $$2: BlockPos_, $$3: number, $$4: Internal.PoiManager$Occupancy_): Internal.Stream<BlockPos>;
        findClosest(predicate: Internal.Predicate_<any>, pos: BlockPos_, radius: number, status: Internal.PoiManager$Occupancy_): Internal.Optional<any>;
        remove($$0: BlockPos_): void;
        static readonly MAX_VILLAGE_DISTANCE: 6;
        static readonly VILLAGE_SECTION_SIZE: 1;
    }
    type PoiManager_ = PoiManager;
    class DirectionalSlimeFluid$Flowing extends Internal.DirectionalSlimeFluid {
        constructor(properties: any_)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type DirectionalSlimeFluid$Flowing_ = DirectionalSlimeFluid$Flowing;
    interface StructureBlockEntityExtensions {
        getQualifiedTestName(): string;
        setQualifiedTestName(qualifiedTestName: string): void;
        get qualifiedTestName(): string
        set qualifiedTestName(qualifiedTestName: string)
    }
    type StructureBlockEntityExtensions_ = StructureBlockEntityExtensions;
    class PotatoCannonItem$Ammo extends Internal.Record {
        constructor(stack: Internal.ItemStack_, type: Internal.PotatoCannonProjectileType_)
        stack(): Internal.ItemStack;
        type(): Internal.PotatoCannonProjectileType;
    }
    type PotatoCannonItem$Ammo_ = PotatoCannonItem$Ammo;
    class VoxelShapeAlignedCuboid extends Internal.VoxelShapeSimpleCube {
        constructor(voxels: Internal.DiscreteVoxelShape_, minX: number, minY: number, minZ: number, maxX: number, maxY: number, maxZ: number, xyzResolution: number)
        constructor(minX: number, minY: number, minZ: number, maxX: number, maxY: number, maxZ: number, xRes: number, yRes: number, zRes: number)
    }
    type VoxelShapeAlignedCuboid_ = VoxelShapeAlignedCuboid;
    class SearedBlock extends Internal.Block implements Internal.LandPathNodeTypesRegistry$StaticPathNodeTypeProvider, Internal.EntityBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getPathNodeType(state: Internal.BlockState_, neighbor: boolean): Internal.BlockPathTypes;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly IN_STRUCTURE: Internal.BooleanProperty;
    }
    type SearedBlock_ = SearedBlock;
    abstract class RecipeSerializerBase <T extends Internal.Recipe<any>> implements Internal.RecipeSerializer<T> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        abstract fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): T;
        getRegistryType(): Internal.RecipeSerializer<any>;
        getRegistryName(): ResourceLocation;
        abstract fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): T;
        setRegistryName(name: ResourceLocation_): this;
        abstract toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: T): void;
        get registryType(): Internal.RecipeSerializer<any>
        get registryName(): ResourceLocation
        set registryName(name: ResourceLocation_)
    }
    type RecipeSerializerBase_<T extends Internal.Recipe<any>> = RecipeSerializerBase<T>;
    interface KeyMappingAccessor {
        abstract getKey(): Internal.InputConstants$Key;
        get key(): Internal.InputConstants$Key
        (): Internal.InputConstants$Key_;
    }
    type KeyMappingAccessor_ = KeyMappingAccessor;
    interface Float2FloatFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.DoubleUnaryOperator {
        andThenObject<T>(arg0: Internal.Float2ObjectFunction_<T>): Internal.Float2ObjectFunction<T>;
        compose(arg0: Internal.DoubleUnaryOperator_): Internal.DoubleUnaryOperator;
        andThenReference<T>(arg0: Internal.Float2ReferenceFunction_<T>): Internal.Float2ReferenceFunction<T>;
        composeFloat(arg0: Internal.Float2FloatFunction_): this;
        composeByte(arg0: Internal.Byte2FloatFunction_): Internal.Byte2FloatFunction;
        composeDouble(arg0: Internal.Double2FloatFunction_): Internal.Double2FloatFunction;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        abstract get(arg0: number): number;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        composeInt(arg0: Internal.Int2FloatFunction_): Internal.Int2FloatFunction;
        andThenChar(arg0: Internal.Float2CharFunction_): Internal.Float2CharFunction;
        andThenLong(arg0: Internal.Float2LongFunction_): Internal.Float2LongFunction;
        defaultReturnValue(arg0: number): void;
        composeShort(arg0: Internal.Short2FloatFunction_): Internal.Short2FloatFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        getOrDefault(arg0: number, arg1: number): number;
        composeChar(arg0: Internal.Char2FloatFunction_): Internal.Char2FloatFunction;
        andThenInt(arg0: Internal.Float2IntFunction_): Internal.Float2IntFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        containsKey(arg0: number): boolean;
        composeReference<T>(arg0: Internal.Reference2FloatFunction_<T>): Internal.Reference2FloatFunction<T>;
        defaultReturnValue(): number;
        identity(): this;
        andThenShort(arg0: Internal.Float2ShortFunction_): Internal.Float2ShortFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        /**
         * @deprecated
        */
        applyAsDouble(arg0: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        put(arg0: number, arg1: number): number;
        apply(arg0: number): number;
        composeLong(arg0: Internal.Long2FloatFunction_): Internal.Long2FloatFunction;
        size(): number;
        andThen(arg0: Internal.DoubleUnaryOperator_): Internal.DoubleUnaryOperator;
        remove(arg0: number): number;
        clear(): void;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        composeObject<T>(arg0: Internal.Object2FloatFunction_<T>): Internal.Object2FloatFunction<T>;
        andThenFloat(arg0: Internal.Float2FloatFunction_): this;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        andThenDouble(arg0: Internal.Float2DoubleFunction_): Internal.Float2DoubleFunction;
        andThenByte(arg0: Internal.Float2ByteFunction_): Internal.Float2ByteFunction;
        (arg0: number): number;
    }
    type Float2FloatFunction_ = Float2FloatFunction;
    class VoxelShapeEmpty extends Internal.VoxelShape implements Internal.VoxelShapeCaster {
        constructor(voxels: Internal.DiscreteVoxelShape_)
        intersects(box: Internal.AABB_, blockX: number, blockY: number, blockZ: number): boolean;
    }
    type VoxelShapeEmpty_ = VoxelShapeEmpty;
    class UnitTokenStream {
        constructor(context: Internal.UnitContext_, input: string)
        peekToken(): Internal.UnitToken;
        readFully(): Internal.UnitToken;
        nextToken(): Internal.UnitToken;
        getUnit(): Internal.Unit;
        ifNextToken(token: Internal.UnitToken_): boolean;
        readSingleToken(): Internal.UnitToken;
        get unit(): Internal.Unit
        readonly context: Internal.UnitContext;
        readonly input: string;
        readonly charStream: Internal.CharStream;
        readonly unit: Internal.Unit;
        readonly inputStringPos: Internal.ArrayList<number>;
        readonly infix: Internal.ArrayList<Internal.UnitToken>;
    }
    type UnitTokenStream_ = UnitTokenStream;
    class FluidBucketItem extends Internal.BucketItem {
        constructor(data: Internal.FluidData_, properties: Internal.Item$Properties_)
        arch$getFluid(): Internal.Fluid;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getData(): Internal.FluidData;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get data(): Internal.FluidData
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type FluidBucketItem_ = FluidBucketItem;
    interface AccessorBogeyStyle {
        abstract getSizeRenderers(): Internal.Map<Internal.BogeySizes$BogeySize, Internal.BogeyStyle$SizeRenderer>;
        get sizeRenderers(): Internal.Map<Internal.BogeySizes$BogeySize, Internal.BogeyStyle$SizeRenderer>
        (): Internal.Map_<Internal.BogeySizes$BogeySize, Internal.BogeyStyle$SizeRenderer>;
    }
    type AccessorBogeyStyle_ = AccessorBogeyStyle;
    class SmokerBlockEntity extends Internal.AbstractFurnaceBlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        stopOpen($$0: Internal.Player_): void;
        stopListenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        static tryClear($$0: any): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        getSlots(): number;
        isSleeping(): boolean;
        setChanged(): void;
        onLoad(): void;
        sleepOnlyCurrentTick(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        asComponentProvider(): Internal.ComponentProvider;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        wakeUpNow(): void;
        fabric_onTransfer(slot: number, transaction: Internal.TransactionContext_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setTicker(delegate: Internal.TickingBlockEntity_): void;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        emitCallbackReplaced(): void;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isEmpty(): boolean;
        startOpen($$0: Internal.Player_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        shouldCloseCurrentScreen(): boolean;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        listenForContentChangesOnce(stackList: Internal.LithiumStackList_, inventoryChangeListener: Internal.InventoryChangeListener_): void;
        getHeight(): number;
        countNonEmpty(): number;
        listenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        asContainer(): net.minecraft.world.Container;
        setRecipeUsed($$0: Internal.Level_, $$1: Internal.ServerPlayer_, $$2: Internal.Recipe_<any>): boolean;
        getAllItems(): Internal.List<Internal.ItemStack>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        generateLootLithium(): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        startSleeping(): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get slots(): number
        get sleeping(): boolean
        get width(): number
        get maxStackSize(): number
        set ticker(delegate: Internal.TickingBlockEntity_)
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
    }
    type SmokerBlockEntity_ = SmokerBlockEntity;
    class FenceGateBlockBuilder extends Internal.ShapedBlockBuilder {
        constructor(i: ResourceLocation_)
        behaviour(wt: Internal.WoodType_): this;
        behaviour(wt: string): this;
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        createObject(): Internal.Block;
    }
    type FenceGateBlockBuilder_ = FenceGateBlockBuilder;
    class ModelPart implements Internal.ModelPartInjector, Internal.ModelPartData, Internal.ModelPartAccessor, io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.ModelPartAccessor, Internal.IUpperPartHelper {
        constructor($$0: Internal.List_<Internal.ModelPart$Cube>, $$1: Internal.Map_<string, Internal.ModelPart>)
        copyFrom($$0: Internal.ModelPart_): void;
        offsetRotation($$0: Vec3f_): void;
        porting_lib$children(): Internal.Map<any, any>;
        hasChild($$0: string): boolean;
        setInjectedMesh(mesh: Internal.Mesh_, offsetProvider: Internal.OffsetProvider_): void;
        render($$0: Internal.PoseStack_, $$1: Internal.VertexConsumer_, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number): void;
        loadPose($$0: Internal.PartPose_): void;
        getInitialPose(): Internal.PartPose;
        setPos($$0: number, $$1: number, $$2: number): void;
        visit($$0: Internal.PoseStack_, $$1: Internal.ModelPart$Visitor_): void;
        isEmpty(): boolean;
        getAllParts(): Internal.Stream<Internal.ModelPart>;
        getInjectedMesh(): Internal.Mesh;
        getOffsetProvider(): Internal.OffsetProvider;
        getChild($$0: string): this;
        setInitialPose($$0: Internal.PartPose_): void;
        setRotation($$0: number, $$1: number, $$2: number): void;
        translateAndRotate(matrixStack: Internal.PoseStack_): void;
        flywheel$compile(arg0: Internal.PoseStack$Pose_, arg1: Internal.VertexConsumer_, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): void;
        getChildren(): Internal.ModelPart[];
        isVisible(): boolean;
        render($$0: Internal.PoseStack_, $$1: Internal.VertexConsumer_, $$2: number, $$3: number): void;
        prepareTranslateAndRotate(poseStack: Internal.PoseStack_): void;
        isUpperPart(): boolean;
        handler$hdf000$skinlayers3d$render(poseStack: Internal.PoseStack_, vertexConsumer: Internal.VertexConsumer_, light: number, overlay: number, red: number, green: number, blue: number, alpha: number, ci: Internal.CallbackInfo_): void;
        isHidden(): boolean;
        getRandomCube($$0: Internal.RandomSource_): Internal.ModelPart$Cube;
        setUpperPart(bl: boolean): void;
        porting_lib$cubes(): Internal.List<any>;
        offsetPos($$0: Vec3f_): void;
        flywheel$children(): Internal.Map<any, any>;
        static from(child: Internal.ModelPart_): Internal.ModelPartData;
        resetPose(): void;
        storePose(): Internal.PartPose;
        offsetScale($$0: Vec3f_): void;
        getCuboids(): Internal.ModelCuboid[];
        get initialPose(): Internal.PartPose
        get empty(): boolean
        get allParts(): Internal.Stream<Internal.ModelPart>
        get injectedMesh(): Internal.Mesh
        get offsetProvider(): Internal.OffsetProvider
        set initialPose($$0: Internal.PartPose_)
        get children(): Internal.ModelPart[]
        get visible(): boolean
        get upperPart(): boolean
        get hidden(): boolean
        set upperPart(bl: boolean)
        get cuboids(): Internal.ModelCuboid[]
        zScale: number;
        yScale: number;
        xRot: number;
        cubes: Internal.List<Internal.ModelPart$Cube>;
        zRot: number;
        visible: boolean;
        z: number;
        skipDraw: boolean;
        y: number;
        x: number;
        xScale: number;
        static readonly DEFAULT_SCALE: 1.0;
        yRot: number;
    }
    type ModelPart_ = ModelPart;
    class AdvancementProgress implements Internal.Comparable<Internal.AdvancementProgress>, Internal.AdvancementProgressAccessor {
        constructor()
        getCriteriaProgresses(): Internal.Map<any, any>;
        grantProgress($$0: string): boolean;
        getCriterion($$0: string): Internal.CriterionProgress;
        isDone(): boolean;
        setRequirements(arg0: string[][]): void;
        hasProgress(): boolean;
        getCompletedCriteria(): Internal.Iterable<string>;
        compareTo(arg0: any): number;
        update($$0: Internal.Map_<string, Internal.Criterion>, $$1: string[][]): void;
        getPercent(): number;
        getRequirements(): string[][];
        static fromNetwork($$0: Internal.FriendlyByteBuf_): Internal.AdvancementProgress;
        revokeProgress($$0: string): boolean;
        getRemainingCriteria(): Internal.Iterable<string>;
        getProgressText(): string;
        getFirstProgressDate(): Internal.Date;
        serializeToNetwork($$0: Internal.FriendlyByteBuf_): void;
        compareTo($$0: Internal.AdvancementProgress_): number;
        get criteriaProgresses(): Internal.Map<any, any>
        get done(): boolean
        set requirements(arg0: string[][])
        get completedCriteria(): Internal.Iterable<string>
        get percent(): number
        get requirements(): string[][]
        get remainingCriteria(): Internal.Iterable<string>
        get progressText(): string
        get firstProgressDate(): Internal.Date
    }
    type AdvancementProgress_ = AdvancementProgress;
    class DataVersion {
        constructor($$0: number, $$1: string)
        constructor($$0: number)
        isSideSeries(): boolean;
        getSeries(): string;
        getVersion(): number;
        isCompatible($$0: Internal.DataVersion_): boolean;
        get sideSeries(): boolean
        get series(): string
        get version(): number
        static MAIN_SERIES: "main";
    }
    type DataVersion_ = DataVersion;
    interface LootPoolExtensions {
        setName(name: string): void;
        getName(): string;
        set name(name: string)
        get name(): string
    }
    type LootPoolExtensions_ = LootPoolExtensions;
    class RemoveSpawnsProperties {
        constructor()
        mobs: Internal.MobFilter;
        biomes: Internal.BiomeFilter;
    }
    type RemoveSpawnsProperties_ = RemoveSpawnsProperties;
    class ClientboundSetPlayerTeamPacket$Action extends Internal.Enum<Internal.ClientboundSetPlayerTeamPacket$Action> {
        static values(): Internal.ClientboundSetPlayerTeamPacket$Action[];
        static valueOf($$0: string): Internal.ClientboundSetPlayerTeamPacket$Action;
        static readonly REMOVE: Internal.ClientboundSetPlayerTeamPacket$Action;
        static readonly ADD: Internal.ClientboundSetPlayerTeamPacket$Action;
    }
    type ClientboundSetPlayerTeamPacket$Action_ = "remove" | ClientboundSetPlayerTeamPacket$Action | "add";
    class Font implements Internal.Serializable {
        constructor(arg0: Internal.Map_<Internal.AttributedCharacterIterator$Attribute, any>)
        constructor(arg0: string, arg1: number, arg2: number)
        deriveFont(arg0: Internal.AffineTransform_): this;
        static createFonts(arg0: Internal.InputStream_): Internal.Font[];
        createGlyphVector(arg0: Internal.FontRenderContext_, arg1: string[]): Internal.GlyphVector;
        canDisplay(arg0: number): boolean;
        static decode(arg0: string): Internal.Font;
        createGlyphVector(arg0: Internal.FontRenderContext_, arg1: number[]): Internal.GlyphVector;
        getStringBounds(arg0: string, arg1: Internal.FontRenderContext_): Internal.Rectangle2D;
        deriveFont(arg0: number, arg1: Internal.AffineTransform_): this;
        getSize(): number;
        canDisplayUpTo(arg0: string[], arg1: number, arg2: number): number;
        getLineMetrics(arg0: string[], arg1: number, arg2: number, arg3: Internal.FontRenderContext_): Internal.LineMetrics;
        getFontName(arg0: Internal.Locale_): string;
        canDisplayUpTo(arg0: string): number;
        static getFont(arg0: string): Internal.Font;
        getFamily(arg0: Internal.Locale_): string;
        getStringBounds(arg0: Internal.CharacterIterator_, arg1: number, arg2: number, arg3: Internal.FontRenderContext_): Internal.Rectangle2D;
        static getFont(arg0: Internal.Map_<Internal.AttributedCharacterIterator$Attribute, any>): Internal.Font;
        deriveFont(arg0: number): this;
        getLineMetrics(arg0: string, arg1: number, arg2: number, arg3: Internal.FontRenderContext_): Internal.LineMetrics;
        createGlyphVector(arg0: Internal.FontRenderContext_, arg1: string): Internal.GlyphVector;
        static textRequiresLayout(arg0: string[], arg1: number, arg2: number): boolean;
        getLineMetrics(arg0: string, arg1: Internal.FontRenderContext_): Internal.LineMetrics;
        getBaselineFor(arg0: string): number;
        static createFont(arg0: number, arg1: Internal.InputStream_): Internal.Font;
        deriveFont(arg0: number, arg1: number): this;
        deriveFont(arg0: Internal.Map_<Internal.AttributedCharacterIterator$Attribute, any>): this;
        getNumGlyphs(): number;
        canDisplay(arg0: string): boolean;
        getItalicAngle(): number;
        getMaxCharBounds(arg0: Internal.FontRenderContext_): Internal.Rectangle2D;
        isBold(): boolean;
        getTransform(): Internal.AffineTransform;
        getStringBounds(arg0: string, arg1: number, arg2: number, arg3: Internal.FontRenderContext_): Internal.Rectangle2D;
        isTransformed(): boolean;
        getStyle(): number;
        getFontName(): string;
        getSize2D(): number;
        isItalic(): boolean;
        createGlyphVector(arg0: Internal.FontRenderContext_, arg1: Internal.CharacterIterator_): Internal.GlyphVector;
        getName(): string;
        getAttributes(): Internal.Map<Internal.TextAttribute, any>;
        getFamily(): string;
        getAvailableAttributes(): Internal.AttributedCharacterIterator$Attribute[];
        getMissingGlyphCode(): number;
        isPlain(): boolean;
        getPSName(): string;
        hasUniformLineMetrics(): boolean;
        static getFont(arg0: string, arg1: Internal.Font_): Internal.Font;
        canDisplayUpTo(arg0: Internal.CharacterIterator_, arg1: number, arg2: number): number;
        hasLayoutAttributes(): boolean;
        static createFonts(arg0: Internal.File_): Internal.Font[];
        getStringBounds(arg0: string[], arg1: number, arg2: number, arg3: Internal.FontRenderContext_): Internal.Rectangle2D;
        static createFont(arg0: number, arg1: Internal.File_): Internal.Font;
        layoutGlyphVector(arg0: Internal.FontRenderContext_, arg1: string[], arg2: number, arg3: number, arg4: number): Internal.GlyphVector;
        deriveFont(arg0: number): this;
        getLineMetrics(arg0: Internal.CharacterIterator_, arg1: number, arg2: number, arg3: Internal.FontRenderContext_): Internal.LineMetrics;
        get size(): number
        get numGlyphs(): number
        get italicAngle(): number
        get bold(): boolean
        get transform(): Internal.AffineTransform
        get transformed(): boolean
        get style(): number
        get fontName(): string
        get size2D(): number
        get italic(): boolean
        get name(): string
        get attributes(): Internal.Map<Internal.TextAttribute, any>
        get family(): string
        get availableAttributes(): Internal.AttributedCharacterIterator$Attribute[]
        get missingGlyphCode(): number
        get plain(): boolean
        get PSName(): string
        static readonly MONOSPACED: "Monospaced";
        static readonly BOLD: 1;
        static readonly TRUETYPE_FONT: 0;
        static readonly DIALOG_INPUT: "DialogInput";
        static readonly LAYOUT_NO_LIMIT_CONTEXT: 4;
        static readonly ITALIC: 2;
        static readonly CENTER_BASELINE: 1;
        static readonly TYPE1_FONT: 1;
        static readonly DIALOG: "Dialog";
        static readonly LAYOUT_RIGHT_TO_LEFT: 1;
        static readonly LAYOUT_NO_START_CONTEXT: 2;
        static readonly PLAIN: 0;
        static readonly LAYOUT_LEFT_TO_RIGHT: 0;
        static readonly SERIF: "Serif";
        static readonly HANGING_BASELINE: 2;
        static readonly ROMAN_BASELINE: 0;
        static readonly SANS_SERIF: "SansSerif";
    }
    type Font_ = Font;
    interface Int2ObjectFunction <V> extends Internal.IntFunction<V>, it.unimi.dsi.fastutil.Function<number, V> {
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        composeLong(arg0: Internal.Long2IntFunction_): Internal.Long2ObjectFunction<V>;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Int2CharFunction;
        put(arg0: number, arg1: V): V;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        containsKey(arg0: number): boolean;
        composeReference<T>(arg0: Internal.Reference2IntFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        abstract get(arg0: number): V;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Int2ReferenceFunction<T>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Int2ByteFunction;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        apply(arg0: number): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        apply(arg0: number): V;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        composeInt(arg0: Internal.Int2IntFunction_): this;
        composeByte(arg0: Internal.Byte2IntFunction_): Internal.Byte2ObjectFunction<V>;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Int2DoubleFunction;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Int2IntFunction;
        composeObject<T>(arg0: Internal.Object2IntFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        remove(arg0: number): V;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Int2ShortFunction;
        getOrDefault(arg0: number, arg1: V): V;
        composeShort(arg0: Internal.Short2IntFunction_): Internal.Short2ObjectFunction<V>;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Int2FloatFunction;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Int2ObjectFunction<T>;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Int2LongFunction;
        composeDouble(arg0: Internal.Double2IntFunction_): Internal.Double2ObjectFunction<V>;
        size(): number;
        composeChar(arg0: Internal.Char2IntFunction_): Internal.Char2ObjectFunction<V>;
        clear(): void;
        defaultReturnValue(): V;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        composeFloat(arg0: Internal.Float2IntFunction_): Internal.Float2ObjectFunction<V>;
        (arg0: number): V;
    }
    type Int2ObjectFunction_<V> = Int2ObjectFunction<V>;
    class SimplePlayerEventJS extends Internal.PlayerEventJS {
        constructor(p: Internal.Player_)
        getEntity(): Internal.Entity;
        get entity(): Internal.Entity
    }
    type SimplePlayerEventJS_ = SimplePlayerEventJS;
    class ClientboundBlockEntityDataPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: BlockPos_, $$1: Internal.BlockEntityType_<any>, $$2: Internal.CompoundTag_)
        handle(arg0: Internal.PacketListener_): void;
        getPos(): BlockPos;
        write($$0: Internal.FriendlyByteBuf_): void;
        static create($$0: Internal.BlockEntity_, $$1: Internal.Function_<Internal.BlockEntity, Internal.CompoundTag>): Internal.ClientboundBlockEntityDataPacket;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getTag(): Internal.CompoundTag;
        isSkippable(): boolean;
        getType(): Internal.BlockEntityType<any>;
        static create($$0: Internal.BlockEntity_): Internal.ClientboundBlockEntityDataPacket;
        get pos(): BlockPos
        get tag(): Internal.CompoundTag
        get skippable(): boolean
        get type(): Internal.BlockEntityType<any>
    }
    type ClientboundBlockEntityDataPacket_ = ClientboundBlockEntityDataPacket;
    class ShapedDurabilityRecipe extends Internal.ShapedRecipe {
        constructor(id: ResourceLocation_, group: string, category: Internal.CraftingBookCategory_, width: number, height: number, input: Internal.NonNullList_<Internal.Ingredient>, output: Internal.ItemStack_, damageAmount: number)
        static bookshelf$dissolvePattern(pattern: string[], ingredients: Internal.Map_<string, Internal.Ingredient>, width: number, height: number): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        getRemainingItems(arg0: net.minecraft.world.Container_): Internal.NonNullList<any>;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems(inv: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        static bookshelf$shrink(...pattern: string[]): string[];
        static bookshelf$patternFromJson(json: Internal.JsonArray_): string[];
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        static bookshelf$keyFromJson($$0: Internal.JsonObject_): Internal.Map<string, Internal.Ingredient>;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get mod(): string
        static readonly SERIALIZER: Internal.ShapedDurabilityRecipe$Serializer;
    }
    type ShapedDurabilityRecipe_ = ShapedDurabilityRecipe;
    interface TabOrderedElement {
        getTabOrderGroup(): number;
        get tabOrderGroup(): number
    }
    type TabOrderedElement_ = TabOrderedElement;
    abstract class BlockEntityBehaviour {
        constructor(be: Internal.SmartBlockEntity_)
        getWorld(): Internal.Level;
        isSafeNBT(): boolean;
        destroy(): void;
        write(nbt: Internal.CompoundTag_, clientPacket: boolean): void;
        onNeighborChanged(neighborPos: BlockPos_): void;
        static get<T extends Internal.BlockEntityBehaviour>(reader: Internal.BlockGetter_, pos: BlockPos_, type: Internal.BehaviourType_<T>): T;
        writeSafe(nbt: Internal.CompoundTag_): void;
        tick(): void;
        getPos(): BlockPos;
        lazyTick(): void;
        unload(): void;
        read(nbt: Internal.CompoundTag_, clientPacket: boolean): void;
        getRequiredItems(): Internal.ItemRequirement;
        setLazyTickRate(slowTickRate: number): void;
        onBlockChanged(oldState: Internal.BlockState_): void;
        abstract getType(): Internal.BehaviourType<any>;
        static get<T extends Internal.BlockEntityBehaviour>(be: Internal.BlockEntity_, type: Internal.BehaviourType_<T>): T;
        initialize(): void;
        get world(): Internal.Level
        get safeNBT(): boolean
        get pos(): BlockPos
        get requiredItems(): Internal.ItemRequirement
        set lazyTickRate(slowTickRate: number)
        get type(): Internal.BehaviourType<any>
        blockEntity: Internal.SmartBlockEntity;
    }
    type BlockEntityBehaviour_ = BlockEntityBehaviour;
    class RegistrateLangProvider extends Internal.BaseLangProvider implements Internal.RegistrateProvider {
        constructor(owner: Internal.AbstractRegistrate_<any>, packOutput: Internal.FabricDataOutput_)
        addBlock(key: Internal.Supplier_<Internal.Block>, name: string): void;
        addTooltip(item: Internal.NonNullSupplier_<Internal.ItemLike>, tooltip: string): void;
        static saveStable($$0: Internal.CachedOutput_, $$1: Internal.JsonElement_, $$2: Internal.Path_): Internal.CompletableFuture<any>;
        addTooltip(item: Internal.NonNullSupplier_<Internal.ItemLike>, tooltip: Internal.List_<string>): void;
        getAutomaticName<T>(sup: Internal.NonNullSupplier_<T>, registry: Internal.ResourceKey_<Internal.Registry<T>>): string;
        add(tab: Internal.CreativeModeTab_, name: string): void;
        add(key: Internal.Item_, name: string): void;
        add(key: Internal.ItemStack_, name: string): void;
        add(key: Internal.Block_, name: string): void;
        addEntityType(key: Internal.Supplier_<Internal.EntityType<any>>, name: string): void;
        addBlockWithTooltip(block: Internal.NonNullSupplier_<Internal.Block>, tooltip: string): void;
        addBlockWithTooltip(block: Internal.NonNullSupplier_<Internal.Block>, name: string, tooltip: string): void;
        addItemStack(key: Internal.Supplier_<Internal.ItemStack>, name: string): void;
        add(key: Internal.EntityType_<any>, name: string): void;
        getSide(): Internal.EnvType;
        addItemWithTooltip(block: Internal.NonNullSupplier_<Internal.Item>, name: string, tooltip: Internal.List_<string>): void;
        addBlock(block: Internal.NonNullSupplier_<Internal.Block>): void;
        static toEnglishName(internalName: string): string;
        addItem(item: Internal.NonNullSupplier_<Internal.Item>): void;
        addEntityType(entity: Internal.NonNullSupplier_<Internal.EntityType<any>>): void;
        add(key: Internal.MobEffect_, name: string): void;
        addItem(key: Internal.Supplier_<Internal.Item>, name: string): void;
        addEnchantment(key: Internal.Supplier_<Internal.Enchantment>, name: string): void;
        addEffect(key: Internal.Supplier_<Internal.MobEffect>, name: string): void;
        add(key: Internal.Enchantment_, name: string): void;
        get side(): Internal.EnvType
    }
    type RegistrateLangProvider_ = RegistrateLangProvider;
    abstract class AbstractSequentialList <E> extends Internal.AbstractList<E> {
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        addLast(arg0: E): void;
        get(arg0: number): E;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        getLast(): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        removeFirst(): E;
        parallelStream(): Internal.Stream<E>;
        sort(arg0: Internal.Comparator_<E>): void;
        set(arg0: number, arg1: E): E;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        static of<E>(...arg0: E[]): Internal.List<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        reversed(): Internal.SequencedCollection<any>;
        remove(arg0: number): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        replaceAll(arg0: Internal.UnaryOperator_<E>): void;
        addFirst(arg0: E): void;
        forEach(arg0: Internal.Consumer_<E>): void;
        abstract toArray<T>(arg0: T[]): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        abstract listIterator(arg0: number): Internal.ListIterator<E>;
        getFirst(): E;
        iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        stream(): Internal.Stream<E>;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        spliterator(): Internal.Spliterator<E>;
        removeLast(): E;
        get last(): E
        get first(): E
    }
    type AbstractSequentialList_<E> = AbstractSequentialList<E>;
    class DebuggerItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type DebuggerItem_ = DebuggerItem;
    class RootedBootsItem extends Internal.WearableArtifactItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static applyBoneMeal(entity: Internal.LivingEntity_, properties: Internal.FoodProperties_): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type RootedBootsItem_ = RootedBootsItem;
    interface AccessorBlockEntityRenderDispatcher {
        abstract hex$getBlockRenderDispatcher(): Internal.Supplier<Internal.BlockRenderDispatcher>;
        (): Internal.Supplier_<Internal.BlockRenderDispatcher>;
    }
    type AccessorBlockEntityRenderDispatcher_ = AccessorBlockEntityRenderDispatcher;
    abstract class LiquidNullFluid extends Internal.FlowingFluid {
        constructor()
        method_15777(p_76458_: Internal.FluidState_, p_76459_: Internal.BlockGetter_, p_76460_: BlockPos_, p_76461_: Internal.Fluid_, p_76462_: Internal.Direction_): boolean;
        method_15733(p_76464_: Internal.LevelReader_): number;
        method_15787(): Internal.ParticleOptions;
        method_15790(p_76466_: Internal.FluidState_): Internal.BlockState;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
        method_15739(p_76469_: Internal.LevelReader_): number;
    }
    type LiquidNullFluid_ = LiquidNullFluid;
    class ComponentRole extends Internal.Enum<Internal.ComponentRole> {
        isOutput(): boolean;
        static values(): Internal.ComponentRole[];
        isInput(): boolean;
        static valueOf(name: string): Internal.ComponentRole;
        isOther(): boolean;
        get output(): boolean
        get input(): boolean
        get other(): boolean
        static readonly INPUT: Internal.ComponentRole;
        static readonly OTHER: Internal.ComponentRole;
        static readonly OUTPUT: Internal.ComponentRole;
    }
    type ComponentRole_ = "other" | "output" | ComponentRole | "input";
    interface ClientAdvancements$Listener extends Internal.AdvancementList$Listener {
        abstract onAddAdvancementRoot(arg0: Internal.Advancement_): void;
        abstract onRemoveAdvancementRoot(arg0: Internal.Advancement_): void;
        abstract onSelectedTabChanged(arg0: Internal.Advancement_): void;
        abstract onUpdateAdvancementProgress(arg0: Internal.Advancement_, arg1: Internal.AdvancementProgress_): void;
        abstract onRemoveAdvancementTask(arg0: Internal.Advancement_): void;
        abstract onAddAdvancementTask(arg0: Internal.Advancement_): void;
        abstract onAdvancementsCleared(): void;
    }
    type ClientAdvancements$Listener_ = ClientAdvancements$Listener;
    class SpawnDragonSkeleton extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(dt: Internal.EntityType_<Internal.EntityDragonBase>, configFactoryIn: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type SpawnDragonSkeleton_ = SpawnDragonSkeleton;
    class ItemPixieDust extends Internal.ItemGenericFood {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemPixieDust_ = ItemPixieDust;
    class NoColor implements dev.latvian.mods.rhino.mod.util.color.Color {
        constructor()
        getSerializeJS(): string;
        static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        getArgbJS(): number;
        createTextColorJS(): Internal.TextColor;
        specialEquals(o: any, shallow: boolean): boolean;
        getHexJS(): string;
        getRgbJS(): number;
        getFireworkColorJS(): number;
        get serializeJS(): string
        get argbJS(): number
        get hexJS(): string
        get rgbJS(): number
        get fireworkColorJS(): number
    }
    type NoColor_ = NoColor;
    class DetectorRailBlock extends Internal.BaseRailBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly SHAPE: Internal.EnumProperty<Internal.RailShape>;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type DetectorRailBlock_ = DetectorRailBlock;
    class FoundryControllerBlock extends Internal.HeatingControllerBlock {
        constructor(builder: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(pLevel: Internal.Level_, pState: Internal.BlockState_, type: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type FoundryControllerBlock_ = FoundryControllerBlock;
    class MethodInfo {
        constructor(methodInfo: Internal.JavaMembers$MethodInfo_, from: typeof any)
        static getRemappedOrOriginalClass(clazz: typeof any): string;
        setReturnType(returnType: Internal.ITypeInfo_): void;
        getAnnotations(): Internal.List<Internal.Annotation>;
        isAbstract(): boolean;
        setParams(params: Internal.List_<Internal.MethodInfo$ParamInfo>): void;
        getFrom(): Internal.ClassInfo;
        shouldHide(): boolean;
        getMethod(): Internal.Method;
        getParams(): Internal.List<Internal.MethodInfo$ParamInfo>;
        isDefaultMethod(): boolean;
        static getMethodInfo(method: Internal.Method_, from: typeof any): Internal.Optional<Internal.JavaMembers$MethodInfo>;
        setTypeVariables(typeVariables: Internal.List_<Internal.ITypeInfo>): void;
        getName(): string;
        getTypeVariables(): Internal.List<Internal.ITypeInfo>;
        getReturnType(): Internal.ITypeInfo;
        isStatic(): boolean;
        set returnType(returnType: Internal.ITypeInfo_)
        get annotations(): Internal.List<Internal.Annotation>
        get "abstract"(): boolean
        set params(params: Internal.List_<Internal.MethodInfo$ParamInfo>)
        get from(): Internal.ClassInfo
        get method(): Internal.Method
        get params(): Internal.List<Internal.MethodInfo$ParamInfo>
        get defaultMethod(): boolean
        set typeVariables(typeVariables: Internal.List_<Internal.ITypeInfo>)
        get name(): string
        get typeVariables(): Internal.List<Internal.ITypeInfo>
        get returnType(): Internal.ITypeInfo
        get "static"(): boolean
        static readonly RUNTIME: Internal.MinecraftRemapper;
    }
    type MethodInfo_ = MethodInfo;
    class FrameType extends Internal.Enum<Internal.FrameType> {
        getDisplayName(): net.minecraft.network.chat.Component;
        static valueOf($$0: string): Internal.FrameType;
        getName(): string;
        static byName($$0: string): Internal.FrameType;
        getTexture(): number;
        static values(): Internal.FrameType[];
        getChatColor(): Internal.ChatFormatting;
        get displayName(): net.minecraft.network.chat.Component
        get name(): string
        get texture(): number
        get chatColor(): Internal.ChatFormatting
        static readonly TASK: Internal.FrameType;
        static readonly CHALLENGE: Internal.FrameType;
        static readonly GOAL: Internal.FrameType;
    }
    type FrameType_ = "challenge" | FrameType | "goal" | "task";
    interface IEmptyContainer extends Internal.IRecipeContainer {
        stopOpen($$0: Internal.Player_): void;
        count(ingredient: Internal.Ingredient_): number;
        tryClear($$0: any): void;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        /**
         * @deprecated
        */
        removeItem(index: number, count: number): Internal.ItemStack;
        getSlots(): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        setChanged(): void;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        /**
         * @deprecated
        */
        getContainerSize(): number;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        /**
         * @deprecated
        */
        setItem(index: number, stack: Internal.ItemStack_): void;
        getHeight(): number;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        removeItemNoUpdate(index: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        stillValid(player: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        /**
         * @deprecated
        */
        getItem(index: number): Internal.ItemStack;
        find(ingredient: Internal.Ingredient_): number;
        /**
         * @deprecated
        */
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        set transferCooldown(currentTime: number)
        /**
         * @deprecated
        */
        get empty(): boolean
        get slots(): number
        /**
         * @deprecated
        */
        get containerSize(): number
        get height(): number
        get width(): number
        get maxStackSize(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        readonly EMPTY: Internal.IEmptyContainer;
    }
    type IEmptyContainer_ = IEmptyContainer;
    abstract class AWTEvent extends Internal.EventObject {
        constructor(arg0: any, arg1: number)
        constructor(arg0: Internal.Event_)
        paramString(): string;
        setSource(arg0: any): void;
        getID(): number;
        set source(arg0: any)
        get ID(): number
        static readonly TEXT_EVENT_MASK: 1024;
        static readonly FOCUS_EVENT_MASK: 4;
        static readonly HIERARCHY_EVENT_MASK: 32768;
        static readonly PAINT_EVENT_MASK: 8192;
        static readonly ACTION_EVENT_MASK: 128;
        static readonly MOUSE_MOTION_EVENT_MASK: 32;
        static readonly WINDOW_STATE_EVENT_MASK: 262144;
        static readonly COMPONENT_EVENT_MASK: 1;
        static readonly WINDOW_EVENT_MASK: 64;
        static readonly INPUT_METHOD_EVENT_MASK: 2048;
        static readonly RESERVED_ID_MAX: 1999;
        static readonly KEY_EVENT_MASK: 8;
        static readonly INVOCATION_EVENT_MASK: 16384;
        static readonly ADJUSTMENT_EVENT_MASK: 256;
        static readonly ITEM_EVENT_MASK: 512;
        static readonly CONTAINER_EVENT_MASK: 2;
        static readonly MOUSE_EVENT_MASK: 16;
        static readonly HIERARCHY_BOUNDS_EVENT_MASK: 65536;
        static readonly MOUSE_WHEEL_EVENT_MASK: 131072;
        static readonly WINDOW_FOCUS_EVENT_MASK: 524288;
    }
    type AWTEvent_ = AWTEvent;
    interface RecipeComponentFactory extends Internal.CustomJavaToJsWrapper {
        convertJavaToJs(cx: Internal.Context_, scope: Internal.Scriptable_, staticType: typeof any): Internal.Scriptable;
        abstract create(arg0: Internal.Context_, arg1: Internal.Scriptable_, arg2: Internal.Map_<string, any>): Internal.RecipeComponent<any>;
        (arg0: Internal.Context, arg1: Internal.Scriptable, arg2: Internal.Map<string, any>): Internal.RecipeComponent_<any>;
    }
    type RecipeComponentFactory_ = RecipeComponentFactory;
    interface IEventHandler {
        abstract onEvent(arg0: Internal.EventJS_): any;
        (arg0: Internal.EventJS): any;
    }
    type IEventHandler_ = IEventHandler;
    interface TravellingPoint$ITrackSelector extends Internal.BiFunction<Internal.TrackGraph, net.createmod.catnip.data.Pair<boolean, Internal.List<Internal.Map$Entry<Internal.TrackNode, Internal.TrackEdge>>>, Internal.Map$Entry<Internal.TrackNode, Internal.TrackEdge>> {
        andThen<V>(arg0: Internal.Function_<Internal.Map$Entry<Internal.TrackNode, Internal.TrackEdge>, V>): Internal.BiFunction<Internal.TrackGraph, net.createmod.catnip.data.Pair<boolean, Internal.List<Internal.Map$Entry<Internal.TrackNode, Internal.TrackEdge>>>, V>;
        abstract apply(arg0: Internal.TrackGraph_, arg1: net.createmod.catnip.data.Pair_<boolean, Internal.List<Internal.Map$Entry<Internal.TrackNode, Internal.TrackEdge>>>): Internal.Map$Entry<Internal.TrackNode, Internal.TrackEdge>;
        (arg0: Internal.TrackGraph, arg1: net.createmod.catnip.data.Pair<boolean, Internal.List<Internal.Map$Entry<Internal.TrackNode, Internal.TrackEdge>>>): Internal.Map$Entry_<Internal.TrackNode, Internal.TrackEdge>;
    }
    type TravellingPoint$ITrackSelector_ = TravellingPoint$ITrackSelector;
    class ShapelessRecipe implements Internal.CraftingRecipe {
        constructor($$0: ResourceLocation_, $$1: string, $$2: Internal.CraftingBookCategory_, $$3: Internal.ItemStack_, $$4: Internal.NonNullList_<Internal.Ingredient>)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        matches($$0: Internal.CraftingContainer_, $$1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        assemble($$0: Internal.CraftingContainer_, $$1: Internal.RegistryAccess_): Internal.ItemStack;
        category(): Internal.CraftingBookCategory;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        "handler$cic000$fabric-recipe-api-v1$customIngredientMatch"(craftingInventory: Internal.CraftingContainer_, world: Internal.Level_, cir: Internal.CallbackInfoReturnable_<any>): void;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem($$0: Internal.RegistryAccess_): Internal.ItemStack;
        canCraftInDimensions($$0: number, $$1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        readonly ingredients: Internal.NonNullList<Internal.Ingredient>;
        readonly result: Internal.ItemStack;
        readonly group: string;
    }
    type ShapelessRecipe_ = ShapelessRecipe;
    class DeferralBehaviour extends Internal.BlockEntityBehaviour {
        constructor(be: Internal.SmartBlockEntity_, callback: Internal.Supplier_<boolean>)
        scheduleUpdate(): void;
        static readonly TYPE: Internal.BehaviourType<Internal.DeferralBehaviour>;
    }
    type DeferralBehaviour_ = DeferralBehaviour;
    interface ItemEntityKJS extends Internal.EntityKJS {
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        getTicksUntilDespawn(): number;
        setNoPickUpDelay(): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        isAmbientCreature(): boolean;
        setTicksUntilDespawn(ticks: number): void;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        isLiving(): boolean;
        setDefaultPickUpDelay(): void;
        getLifespan(): number;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setInfinitePickUpDelay(): void;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        attack(hp: number): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getPersistentData(): Internal.CompoundTag;
        setNoDespawn(): void;
        getMotionZ(): number;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setLifespan(lifespan: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get ticksUntilDespawn(): number
        get ambientCreature(): boolean
        set ticksUntilDespawn(ticks: number)
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get lifespan(): number
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        get motionX(): number
        get waterCreature(): boolean
        get persistentData(): Internal.CompoundTag
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set lifespan(lifespan: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type ItemEntityKJS_ = ItemEntityKJS;
    class BanDetails extends Internal.Record {
        constructor(id: Internal.UUID_, expires: Internal.Instant_, reason: string, reasonMessage: string)
        id(): Internal.UUID;
        expires(): Internal.Instant;
        reasonMessage(): string;
        reason(): string;
        static readonly MULTIPLAYER_SCOPE: "MULTIPLAYER";
    }
    type BanDetails_ = BanDetails;
    class GameRules$Type <T extends Internal.GameRules$Value<T>> {
        constructor($$0: Internal.Supplier_<Internal.ArgumentType<any>>, $$1: Internal.Function_<Internal.GameRules$Type<T>, T>, $$2: Internal.BiConsumer_<Internal.MinecraftServer, T>, $$3: any_<T>)
        callVisitor($$0: Internal.GameRules$GameRuleTypeVisitor_, $$1: Internal.GameRules$Key_<T>): void;
        createRule(): T;
        createArgument($$0: string): Internal.RequiredArgumentBuilder<Internal.CommandSourceStack, any>;
    }
    type GameRules$Type_<T extends Internal.GameRules$Value<T>> = GameRules$Type<T>;
    class BookCopyAttribute$Type implements Internal.ItemAttributeType {
        constructor()
        getAllAttributes(stack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemAttribute>;
        createAttribute(): Internal.ItemAttribute;
    }
    type BookCopyAttribute$Type_ = BookCopyAttribute$Type;
    class BeeDebugRenderer implements Internal.DebugRenderer$SimpleDebugRenderer {
        constructor($$0: Internal.Minecraft_)
        render($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: number, $$3: number, $$4: number): void;
        addOrUpdateHiveInfo($$0: Internal.BeeDebugRenderer$HiveInfo_): void;
        removeBeeInfo($$0: number): void;
        addOrUpdateBeeInfo($$0: Internal.BeeDebugRenderer$BeeInfo_): void;
        clear(): void;
    }
    type BeeDebugRenderer_ = BeeDebugRenderer;
    abstract class HitResult {
        distanceTo($$0: Internal.Entity_): number;
        getLocation(): Vec3d;
        abstract getType(): Internal.HitResult$Type;
        get location(): Vec3d
        get type(): Internal.HitResult$Type
    }
    type HitResult_ = HitResult;
    abstract class StockCheckingBlockEntity extends Internal.SmartBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        broadcastPackageRequest(type: Internal.LogisticallyLinkedBehaviour$RequestType_, order: Internal.PackageOrderWithCrafts_, ignoredHandler: Internal.IdentifiedInventory_, address: string): boolean;
        getRecentSummary(): Internal.InventorySummary;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAccurateSummary(): Internal.InventorySummary;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        broadcastPackageRequest(type: Internal.LogisticallyLinkedBehaviour$RequestType_, order: Internal.PackageOrder_, ignoredHandler: Internal.IdentifiedInventory_, address: string): boolean;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get recentSummary(): Internal.InventorySummary
        get infiniteBoundingBox(): Internal.AABB
        get accurateSummary(): Internal.InventorySummary
        behaviour: Internal.LogisticallyLinkedBehaviour;
    }
    type StockCheckingBlockEntity_ = StockCheckingBlockEntity;
    interface Float2ObjectFunction <V> extends Internal.DoubleFunction<V>, it.unimi.dsi.fastutil.Function<number, V> {
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Float2FloatFunction;
        composeReference<T>(arg0: Internal.Reference2FloatFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        composeLong(arg0: Internal.Long2FloatFunction_): Internal.Long2ObjectFunction<V>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        composeByte(arg0: Internal.Byte2FloatFunction_): Internal.Byte2ObjectFunction<V>;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Float2CharFunction;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        getOrDefault(arg0: number, arg1: V): V;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeObject<T>(arg0: Internal.Object2FloatFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        composeChar(arg0: Internal.Char2FloatFunction_): Internal.Char2ObjectFunction<V>;
        composeDouble(arg0: Internal.Double2FloatFunction_): Internal.Double2ObjectFunction<V>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Float2ByteFunction;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        remove(arg0: number): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        composeFloat(arg0: Internal.Float2FloatFunction_): this;
        abstract get(arg0: number): V;
        containsKey(arg0: number): boolean;
        /**
         * @deprecated
        */
        apply(arg0: number): V;
        apply(arg0: number): V;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Float2IntFunction;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Float2LongFunction;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Float2ObjectFunction<T>;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Float2ShortFunction;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Float2DoubleFunction;
        size(): number;
        composeShort(arg0: Internal.Short2FloatFunction_): Internal.Short2ObjectFunction<V>;
        clear(): void;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        defaultReturnValue(): V;
        put(arg0: number, arg1: V): V;
        composeInt(arg0: Internal.Int2FloatFunction_): Internal.Int2ObjectFunction<V>;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Float2ReferenceFunction<T>;
        (arg0: number): V;
    }
    type Float2ObjectFunction_<V> = Float2ObjectFunction<V>;
    interface BooleanBidirectionalIterator extends Internal.BooleanIterator, Internal.ObjectBidirectionalIterator<boolean> {
        /**
         * @deprecated
        */
        forEachRemaining(arg0: Internal.Consumer_<boolean>): void;
        forEachRemaining(arg0: any): void;
        abstract hasPrevious(): boolean;
        remove(): void;
        skip(arg0: number): number;
        /**
         * @deprecated
        */
        next(): any;
        /**
         * @deprecated
        */
        previous(): boolean;
        abstract nextBoolean(): boolean;
        back(arg0: number): number;
        abstract hasNext(): boolean;
        abstract previousBoolean(): boolean;
        forEachRemaining(arg0: it.unimi.dsi.fastutil.booleans.BooleanConsumer_): void;
    }
    type BooleanBidirectionalIterator_ = BooleanBidirectionalIterator;
    class CreativeModeTab$TabVisibility extends Internal.Enum<Internal.CreativeModeTab$TabVisibility> {
        static valueOf($$0: string): Internal.CreativeModeTab$TabVisibility;
        static values(): Internal.CreativeModeTab$TabVisibility[];
        static readonly PARENT_TAB_ONLY: Internal.CreativeModeTab$TabVisibility;
        static readonly SEARCH_TAB_ONLY: Internal.CreativeModeTab$TabVisibility;
        static readonly PARENT_AND_SEARCH_TABS: Internal.CreativeModeTab$TabVisibility;
    }
    type CreativeModeTab$TabVisibility_ = CreativeModeTab$TabVisibility | "parent_and_search_tabs" | "parent_tab_only" | "search_tab_only";
    class AllArmInteractionPointTypes$ComposterType extends Internal.ArmInteractionPointType {
        constructor()
    }
    type AllArmInteractionPointTypes$ComposterType_ = AllArmInteractionPointTypes$ComposterType;
}
declare namespace io.github.fabricators_of_create.porting_lib.common.util {
    interface NonNullSupplier <T> extends Internal.Supplier<T> {
        of<T>(sup: Internal.Supplier_<T>, errorMsg: io.github.fabricators_of_create.porting_lib.common.util.NonNullSupplier_<string>): this;
        of<T>(sup: Internal.Supplier_<T>): this;
        abstract get(): T;
        (): T;
    }
    type NonNullSupplier_<T> = NonNullSupplier<T>;
}
declare namespace me.jellysquid.mods.lithium.mixin.chunk.entity_class_groups {
    interface ClientEntityManagerAccessor <T extends Internal.EntityAccess> {
        abstract getCache(): Internal.EntitySectionStorage<T>;
        get cache(): Internal.EntitySectionStorage<T>
        (): Internal.EntitySectionStorage_<T>;
    }
    type ClientEntityManagerAccessor_<T extends Internal.EntityAccess> = ClientEntityManagerAccessor<T>;
}
declare namespace io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor {
    interface ParticleEngineAccessor {
        abstract port_lib$getProviders(): Internal.Int2ObjectMap<Internal.ParticleProvider<any>>;
        (): Internal.Int2ObjectMap_<Internal.ParticleProvider<any>>;
    }
    type ParticleEngineAccessor_ = ParticleEngineAccessor;
}
